# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

import logging

from django.db import connection, transaction

from travel.rasp.admin.lib import tmpfiles
from travel.rasp.admin.lib.logs import create_current_file_run_log, print_log_to_stdout, get_script_log_context, ylog_context
from geosearch.models import NameSearchIndex
from travel.rasp.admin.lib.mysqlutils import MysqlModelLoader


log = logging.getLogger(__name__)


@tmpfiles.clean_temp
@transaction.atomic
def run(truncate_table=False):
    log.info(u'Remove Old Data')

    cursor = connection.cursor()

    if truncate_table:
        log.info(u'Truncating table')
        cursor.execute('TRUNCATE `{}`'.format(NameSearchIndex._meta.db_table))
    else:
        log.info(u'Deleting old data')
        cursor.execute('DELETE FROM `{}`'.format(NameSearchIndex._meta.db_table))

    log.info(u'Loading data')

    with MysqlModelLoader(NameSearchIndex, tmpfiles.get_tmp_dir('namesearchindex')) as loader:
        for nsi in NameSearchIndex.get_records():
            loader.add(nsi)

    log.info(u'Done')

if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        import argparse

        create_current_file_run_log()

        parser = argparse.ArgumentParser()
        parser.add_argument('-v', '--verbose', action='store_true')
        parser.add_argument('--truncate', action='store_true')

        args = parser.parse_args()
        if args.verbose:
            print_log_to_stdout(log)

        run(truncate_table=args.truncate)
