#!/usr/bin/env python
# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

import logging

from django.db import connection
from django.db import models
from django.apps import apps
from filebrowser.models import FileBrowser

from mapping import models as mapping_models
from travel.rasp.admin.lib.logs import print_log_to_stdout, create_current_file_run_log, get_script_log_context, ylog_context
from travel.rasp.admin.lib.mail import mail_process


log = logging.getLogger(__name__)


MAX_MYSQL_INT = 2147483647
MAX_USED_PK_PERCENT = 70


def run():
    models_with_overflow_risk = []

    for model in apps.get_models():
        log.info(u'Проверяем на автоинкремент %s %s', model._meta.app_label, model)
        if model in (mapping_models.Train, mapping_models.LiveBus, FileBrowser):
            log.info(u'Игнорируем проверку таблицы %s %s', model._meta.app_label, model)
            continue

        if not isinstance(model._meta.pk, models.AutoField):
            log.info(u'Игнорируем проверку таблицы %s %s т.к. PRIMARYKEY не числовой',
                     model._meta.app_label, model)
            continue

        cursor = connection.cursor()
        db_name = connection.connection.conn_params['db']
        cursor.execute(
            'SELECT `AUTO_INCREMENT` FROM `INFORMATION_SCHEMA`.`TABLES`'
            ' WHERE TABLE_SCHEMA = %s AND TABLE_NAME = %s', [
                db_name, model._meta.db_table
            ]
        )
        pk_auto_inrement = cursor.fetchone()[0]

        pk_used_percent = int(float(pk_auto_inrement) / MAX_MYSQL_INT * 100)
        if pk_used_percent >= MAX_USED_PK_PERCENT:
            log.warning(u'Автоинкремент переполнен у %s %s', model._meta.app_label, model)
            models_with_overflow_risk.append((model.__name__, pk_used_percent))
        else:
            log.info(u'Автоинкремент в норме у %s %s', model._meta.app_label, model)

    if models_with_overflow_risk:
        mail_process(u'!!!Автоинкременты в базе данных скоро переполнятся',
                     u'\n'.join(u'{} использована на {}%'.format(m, pp) for m, pp in models_with_overflow_risk))


# Если файл запустили из консоли парсим параметры и запускаем скрипт
if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        import argparse
        parser = argparse.ArgumentParser()
        parser.add_argument('-v', '--verbose', action="store_true", help=u"выводить лог на экран")
        args = parser.parse_args()

        if args.verbose:
            print_log_to_stdout()

        create_current_file_run_log()
        run()
