#!/usr/bin/env python
# coding: utf-8

"""Проверка флагов maintenance"""

import travel.rasp.admin.scripts.load_project  # noqa

import sys

from travel.rasp.admin.lib.logs import get_script_log_context, ylog_context
from travel.rasp.admin.lib.maintenance.flags import flags
from travel.rasp.admin.lib.maintenance.scripts import job


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        if len(sys.argv) not in [2, 3]:
            print "Usage: %s <flagname> [<flagstate>]" % sys.argv[0]
            sys.exit(1)

        flag_name = sys.argv[1]

        if len(sys.argv) > 2:
            flag_state = sys.argv[2]

            if flag_state.isdigit():
                flag_state = int(flag_state)
            else:
                maintenance_state = job.get_by_name(flag_state)
                if maintenance_state is None:
                    print "Unknown flag %s state %s" % (flag_name, flag_state)
                    sys.exit(1)

                flag_state = maintenance_state.flag_value
        else:
            flag_state = None

        state = flags[flag_name]

        test_result = False

        if flag_state is not None:
            if flag_state == state:
                test_result = True
        else:
            test_result = state

        if test_result:
            sys.exit(0)
        else:
            sys.exit(1)
