# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

import logging
from optparse import OptionParser

from django.db import transaction

from common.models.schedule import RThread
from travel.rasp.admin.lib.logs import print_log_to_stdout, create_current_file_run_log, get_script_log_context, ylog_context
from travel.rasp.admin.www.utils.mysql import fast_delete_threads


log = logging.getLogger(__name__)


@transaction.atomic
def main():
    for thread in RThread.objects.filter(route__hidden=False, route__script_protected=False,
                                         year_days=372 * '0', thread_changes__isnull=True):
        route = thread.route

        fast_delete_threads(RThread.objects.filter(pk=thread.pk))
        if not route.rthread_set.exists():
            route.delete()

    log.info(u'Скрипт успешно отработал')

usage = u"Usage: python %prog [options]"

# Если файл запустили из консоли парсим параметры и запускаем скрипт
if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        optparser = OptionParser(usage=usage, description=__doc__)
        optparser.add_option('-v', '--verbose', action="store_true",
                             help=u"выводить лог на экран")
        options, args = optparser.parse_args()

        if options.verbose:
            print_log_to_stdout()

        create_current_file_run_log()

        main()
