# -*- encoding: utf-8 -*-

import travel.rasp.admin.scripts.load_project  # noqa

import logging
import os.path
from optparse import OptionParser

from django.db import connection, transaction

from travel.rasp.admin.lib.logs import create_current_file_run_log, print_log_to_stdout, get_script_log_context, ylog_context


script_name = os.path.basename(__file__)

log = logging.getLogger(__name__)


@transaction.atomic
def main():
    cursor = connection.cursor()
    cursor.execute("DELETE FROM www_threadtariff WHERE thread_uid NOT IN (SELECT uid FROM www_rthread);")


usage = u"Usage: python %prog [options]"

# Если файл запустили из консоли парсим параметры и запускаем скрипт
if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        optparser = OptionParser(usage=usage, description=__doc__)
        optparser.add_option('-v', '--verbose', action="store_true",
                             help=u"выводить лог на экран")
        options, args = optparser.parse_args()

        if options.verbose:
            print_log_to_stdout()

        create_current_file_run_log()

        main()
