#!/usr/bin/env python
# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

import logging
import os.path
from optparse import OptionParser

from django.db import connection, transaction

from travel.rasp.admin.lib.maintenance.flags import flags
from travel.rasp.admin.lib.logs import print_log_to_stdout, create_current_file_run_log, get_script_log_context, ylog_context
from travel.rasp.admin.www.utils.mysql import correct_z_tables


script_name = os.path.basename(__file__)

log = logging.getLogger(__name__)


@transaction.atomic
def main():
        # Чистим таблицы от рейсов, которых нет в базе
    cursor = connection.cursor()
    if flags['partial_preparation']:

        correct_z_tables(cursor)

    else:
        cursor.execute("TRUNCATE www_znoderoute2")
        cursor.execute("TRUNCATE www_stationschedule")

    cursor.execute("UPDATE www_route r LEFT JOIN www_company c ON c.id = r.company_id"
                   " SET r.company_id = NULL WHERE c.id IS NULL AND r.company_id IS NOT NULL")

    log.info('Clearing finished')


usage = u"Usage: python %prog [options]"

# Если файл запустили из консоли парсим параметры и запускаем скрипт
if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        optparser = OptionParser(usage=usage, description=__doc__)
        optparser.add_option('-v', '--verbose', action="store_true",
                             help=u"выводить лог на экран")
        options, args = optparser.parse_args()

        if options.verbose:
            print_log_to_stdout()

        create_current_file_run_log()

        main()

