#!/usr/bin/env python
# coding: utf-8

from __future__ import unicode_literals

import travel.rasp.admin.scripts.load_project  # noqa

import logging
import time as time_

from common.models.schedule import RThread
from travel.rasp.admin.lib.logs import print_log_to_stdout, create_current_file_run_log, get_script_log_context, ylog_context
from travel.rasp.admin.lib.mail import mail_process
from travel.rasp.admin.lib.maintenance.flags import flags
from travel.rasp.admin.lib.maintenance.scripts import job
from travel.rasp.admin.scripts.schedule.bus.two_stage_autoimport import tsi_every_day_autoimport
from travel.rasp.admin.scripts.schedule.tis_train.import_tis import update_tis
from travel.rasp.admin.scripts.schedule.update_af_suburban import run as af
from travel.rasp.admin.scripts.utils.daily_update import remove_hide_obsolete_threads, restore_basic_thread_from_changes


log = logging.getLogger(__name__)


script_list = [
    ('af', af, tuple(), dict()),
    ('tis', update_tis, tuple(), dict()),
    ('tsi_every_day_autoimport', tsi_every_day_autoimport, (), {}),
]


def check_af_threads_template_text():
    """Проверяем всем ли основным ниткам от Фетисова указано поле template_text"""
    bad_threads = []
    for t in RThread.objects.filter(route__supplier__code='af',
                                    type__code='basic'):
        if not t.template_text:
            bad_threads.append(t.get_admin_url())
    if bad_threads:
        message = u"\n".join(bad_threads)
        mail_process(u"Не заполнены шаблоны дни хождений", message)


def run(log_handler=None):
    if log_handler:
        log.addHandler(log_handler)

    if flags['maintenance']:
        log.error('Идет работа с базой данных, нельзя запускать обновление')
        return

    if not flags['switch']:
        log.error('Переключение баз выключено, не запускаем обновление.')
        return

    flags['maintenance'] = job.DAILY_UPDATE.flag_value
    try:
        log.info('Чистим нитки изменения')
        restore_basic_thread_from_changes()
        log.info('Удаляем(скрываем) старые нитки, которые не попадают в диапазон -3,+200')
        remove_hide_obsolete_threads()

        log.info('Запускаем скрипты')
        for name, script, params, kwargs in script_list:
            start = time_.time()
            log.info('Запускаем скрипт %s %s %s', name, repr(params).decode('utf8'), repr(kwargs).decode('utf8'))
            script(*params, **kwargs)
            log.info('Скрипт %s отработал за %f', name, time_.time() - start)

        check_af_threads_template_text()

    except Exception:
        log.exception('Ошибка при ежедневном обновлении')
        raise
    finally:
        flags['maintenance'] = False


# Если файл запустили из консоли парсим параметры и запускаем импорт
if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        create_current_file_run_log()

        import argparse

        parser = argparse.ArgumentParser()
        parser.add_argument('-v', '--verbose', action='store_true')

        args = parser.parse_args()

        if args.verbose:
            print_log_to_stdout(log)

        run()
