# coding: utf-8
"""Скрипт переключения баз"""

import travel.rasp.admin.scripts.load_project  # noqa

import cgi
import logging
import os
import random
import sys
import time
from contextlib import closing
from optparse import OptionParser
from signal import SIGKILL

from django.conf import settings
from django.utils.http import urlquote

from common.data_api.file_wrapper.config import get_wrapper_creator
from common.data_api.qloud.api import QloudPublicApi
from common.data_api.sandbox.admin_script_after_run import AdminScripts, admin_script_after_run_task_runner
from common.db import maintenance
from common.db.switcher import switcher, get_replica_sync_checker
from common.dynamic_settings.default import conf
from common.dynamic_settings.core import DynamicSetting
from common.models.timestamp import Timestamp
from common.settings import ServiceInstance, WorkInstance
from common.settings.configuration import Configuration
from travel.rasp.library.python.common23.date import environment
from common.utils.metrics import task_progress_report
from travel.rasp.admin.lib.logs import print_log_to_stdout, copy_std_streams_to_file, get_current_file_run_log_handler, get_script_log_context, ylog_context
from travel.rasp.admin.lib.mail import mail_process
from travel.rasp.admin.lib import metadata_conf
from travel.rasp.admin.lib.maintenance.flags import flags, get_flag, set_flag
from travel.rasp.admin.lib.maintenance.scripts import job
from travel.rasp.admin.lib.mysqlutils import analyze_all_tables, load_dump
from travel.rasp.admin.lib.processes import get_ps_aux_lines
from travel.rasp.admin.scripts.cron_daily_update import run as run_cron_daily_update
from travel.rasp.admin.scripts.cron_switch_copy_files import copy_export_data, copy_media_data, upload_rasp_root
from travel.rasp.admin.scripts.prepare_all import make_action_list as make_prepare_all_action_list
from travel.rasp.admin.scripts.support_methods import StateSaver, run_action_list
from travel.rasp.admin.scripts.utils.file_wrapper.registry import FileType
from travel.rasp.admin.scripts.utils.file_wrapper.mds_utils import get_cron_log_key
from travel.rasp.admin.scripts.utils.file_wrapper.uploaders import ObjWrapperSyncer
from travel.rasp.admin.scripts.utils.lock import get_script_lock


log = logging.getLogger(__name__)

warning_action = settings.SCRIPT_WARNING_ACTION

SERVICE_INSTANCE_PATH = settings.INSTANCE_PATHS[ServiceInstance.code]
WORK_INSTANCE_PATH = settings.INSTANCE_PATHS[WorkInstance.code]
WORK_EXPORT_PATH = getattr(settings, 'WORK_EXPORT_PATH', '{}/www/db/scripts/export/'.format(WORK_INSTANCE_PATH))


conf.register_settings(
    ADMIN_FAIL_LOAD_DUMP_ON_SWITCH_BASES=DynamicSetting(False, cache_time=10)
)


def switch_bases(options, log_file=None):

    if settings.INSTANCE_ROLE.code != 'service':
        log.error(u"Переключение можно запускать только на сервисном инстансе")
        sys.exit(1)

    if not flags['switch']:
        log.error(u"Переключение баз отключено.")
        sys.exit(0)

    # На сервисной базе
    if flags['maintenance']:
        log.error(u"Идет работа с базой данных или предыдущий запуск скрипта завершился некорректно")
        sys.exit(1)

    # На боевой базе
    if get_flag('maintenance', settings.WORK_DB):
        log.error(u"Идет работа на боевой базе")
        sys.exit(1)

    # а) поднять флаг "идет переключение баз"

    log.info(u"Запускаем переключение")
    if conf.ADMIN_FAIL_LOAD_DUMP_ON_SWITCH_BASES:
        log.warning("--------------> switch script will fail on load_service_dump step because manual fail flag is enabled <----------------")

    log.info(u"Поднимаем флаги")

    work_flag_note_parts = [u'Переключение запущено {dt}'.format(dt=environment.now().strftime('%d.%m.%y %H:%M'))]
    if not log_file:
        service_flag_note_parts = work_flag_note_parts
    else:
        work_flag_note_parts += [u'Лог на диске {filepath}'.format(filepath=cgi.escape(log_file.name))]
        service_flag_note_parts = work_flag_note_parts + [
            u'<a href={url}>Cсылка на лог</a>'.format(
                url='/admin/logs/special/script_runs/scripts/cron_switch_bases/{}'.format(
                    urlquote(os.path.basename(log_file.name))
                )
            )
        ]
    service_note = u'<ul>{}</ul>'.format(u''.join([u'<li>{}</li>'.format(part) for part in service_flag_note_parts]))
    work_note = u'<ul>{}</ul>'.format(u''.join([u'<li>{}</li>'.format(part) for part in work_flag_note_parts]))

    set_flag('maintenance', job.SWITCH_BASES.flag_value, note=service_note)
    set_flag('maintenance', job.SWITCH_BASES.flag_value, settings.WORK_DB, note=work_note)

    switch_bases_state_saver = StateSaver('switch_bases_state.txt')

    log.info("Work base - {}, service base - {}".format(
        switcher.get_db_alias(settings.WORK_DB), switcher.get_db_alias(settings.SERVICE_DB)))

    action_group_list = make_action_list(options)

    run_action_list(action_group_list, switch_bases_state_saver, log, on_error, options.is_continue)

    log.info(u"Опускаем флаг")
    # В сервисной базе
    flags['maintenance'] = False

    # Report
    mail_process(u'Weekly database switching', u'Switching finished successfully.')

    log.info("Done")


def on_error(bad_action):
    text = u"%s failed" % bad_action
    log.error(text)
    mail_process(u'Swtich script failed!!!', text)
    sys.exit(1)


def kill_unnecessary_cron_process():
    log.info('== killing work_db cron (mapping) ==')

    process_to_kill = [
        'fill_livemap',
    ]

    def must_die(ps_line):
        for ptk in process_to_kill:
            if ptk in ps_line:
                return True
        return False

    # б) убедиться, что остановлены скрипты из п.1. Если нет - остановить.
    def get_cron_pids():
        return [int(line.split()[1]) for line in get_ps_aux_lines() if must_die(line)]

    for pid in get_cron_pids():
        log.info(u'Kill pid %s', pid)
        try:
            os.kill(pid, SIGKILL)
        except OSError as e:
            log.warning(u'Process %s not found %s', pid, e)


def wait_for_maintenance_cluster_sync():
    param_name = 'sync_key'
    sync_key = str(environment.now()) + ':' + str(random.random())

    def check(connection):
        with closing(connection.cursor()) as cursor:
            cursor.execute('SELECT value FROM conf WHERE name=%s', [param_name])
            row = cursor.fetchone()

        value = row and row[0]
        return value == sync_key

    maintenance.update_conf({param_name: sync_key})

    log.info(u'Ждем когда до реплик доедет значение sync_key=%s', sync_key)
    get_replica_sync_checker(settings.MAINTENANCE_DB, check).run()


def wait_for_service_cluster_sync():
    timestamp_code = 'sync_key'
    sync_key = environment.now().replace(microsecond=0)  # в базу микросекунды не сохраняются

    def check(connection):
        try:
            return sync_key == Timestamp.get_via_connection(timestamp_code, connection)
        except Timestamp.DoesNotExist:
            return False

    Timestamp.objects.update_or_create(code=timestamp_code, defaults={'value': sync_key})

    log.info(u'Ждем когда до реплик доедет значение sync_key=%s', sync_key)
    get_replica_sync_checker(settings.SERVICE_DB, check).run()


def swap_bases():
    # Переключение баз
    switcher.swap(settings.WORK_DB, settings.SERVICE_DB)


def wait_for_real_swap():
    log.info(u"Ждем, пока кластер поймет, что база переключилась, чтобы")
    log.info(u"удаление таблиц на него не повлияло (RASP-6365)")

    time.sleep(600)  # Десять минут


def remove_work_db_flag():
    # Теперь уже можно снимать флаг с боевой базы, чтобы работал экспорт и т.п.
    set_flag('maintenance', False, settings.WORK_DB)


def load_service_dump():
    if conf.ADMIN_FAIL_LOAD_DUMP_ON_SWITCH_BASES:
        raise Exception('Manual fail load_service_dump step')

    dump_filename = os.path.join(WORK_EXPORT_PATH, maintenance.read_conf()['service_db_dump'])
    if not os.path.isfile(dump_filename):
        log.info(u'На диске отсутствует путь к файлу с дампом')
    load_dump(dump_filename)
    log.info(u'Сбрасываем путь к файлу дампа')
    maintenance.update_conf({'service_db_dump': ''})


def analyze_fresh_service_tables():
    switcher.sync_db()
    analyze_all_tables(settings.SERVICE_DB)


def update_metadata_conf_file():
    conf = maintenance.read_conf()
    metadata_conf.write_conf(conf)


def update_last_successful_switch():
    conf = maintenance.read_conf()
    conf['last_successful_switch'] = time.strftime('%Y-%m-%d %H:%M:%S')
    maintenance.write_conf(conf)


PATHFINDER_ENVIRONMENT_BY_APPLIED_CONFIG = {
    Configuration.PRODUCTION: ['rasp.pathfinder-core.production'],
    Configuration.TESTING: ['rasp.pathfinder-core.testing'],
}


def switch_qloud_pathfinder_db():
    api = QloudPublicApi(settings.QLOUD_TOKEN, timeout=30)
    for env_name in PATHFINDER_ENVIRONMENT_BY_APPLIED_CONFIG.get(settings.APPLIED_CONFIG, []):
        api.update_component_environment_variables(env_name, 'main',
                                                   CURRENT_DB=switcher.get_db_alias(settings.WORK_DB))


def start_sandbox_after_run_task():
    admin_script_after_run_task_runner.run(AdminScripts.SWITCH_BASES)


def make_action_list(options):
    params = {'base_path': settings.SCRIPTS_PATH}

    switch_scripts = [
        " --- Switch scripts === ",
        'pa= sitemaps ==',
        (False, ['python', '-W', warning_action, 'sitemap/generate.py']),
        (False, upload_rasp_root),

        " -- Dump -- ",
        (True, ['python', '-W', warning_action, 'make_fresh_dump.py',
                '--db-type', 'service_db',
                '--prefix', 'switching',
                '--skip-flag-checking',
                '--save-filename',
                WORK_EXPORT_PATH]),
        (True, ['python', '-W', warning_action, 'make_fresh_dump.py',
                '--db-type', 'service_db',
                '--prefix', 'switching',
                '--skip-flag-checking', '--schema-only',
                WORK_EXPORT_PATH]),

        " -- Mapping -- ",
        (False, ['python', '-W', warning_action, 'fill_livemap.py', 'train', '20']),
        (False, ['python', '-W', warning_action, 'fill_livemap.py', 'bus', '60']),

        " -- Exports -- ",
        (False, ['python', '-W', warning_action, 'export/export_nearest_suburban.py',
                 'generate-nearest-directions-db-only']),
        (False, ['python', '-W', warning_action, 'export/export_bus_station_codes.py']),

        u" - Copy Media - ",
        (False, copy_media_data),

        (False, kill_unnecessary_cron_process),
        (True, wait_for_service_cluster_sync),
        (True, swap_bases),
        (True, wait_for_maintenance_cluster_sync),

        (True, update_metadata_conf_file),
        (False, switch_qloud_pathfinder_db),
        (False, start_sandbox_after_run_task),

        (True, wait_for_real_swap),
        u"Switch finished. Start dump load.",
        (True, load_service_dump),
        (True, remove_work_db_flag),
        (False, analyze_fresh_service_tables),
        (False, copy_export_data),
        (True, update_last_successful_switch),
    ]
    switch_actions = [(params, switch_scripts)]

    if options.no_prepare_all:
        return switch_actions

    prepare_all_actions = make_prepare_all_action_list(short=False)

    return prepare_all_actions + switch_actions


def run_switch_bases(options, handler):
    if options.verbose:
        print_log_to_stdout()
        with copy_std_streams_to_file(handler.stream.name):
            switch_bases(options, handler.stream)
    else:
        logging.getLogger().addHandler(handler)
        switch_bases(options, handler.stream)


if __name__ == '__main__':
    with get_script_lock(), \
            ylog_context(**get_script_log_context()), task_progress_report('switch_bases'):
        optparser = OptionParser()

        optparser.add_option('-v', '--verbose', action="store_true",
                             help=u"выводить лог на экран")
        optparser.add_option("--continue", dest="is_continue", action="store_true",
                             help=u"продолжить выпольнения с последнего шага")
        optparser.add_option("--no-prepare-all", dest="no_prepare_all", action="store_true",
                             help=u"не запускать действия из prepare_all")
        optparser.add_option("--cron-run", dest="cron_run", action="store_true",
                             help=u"запущен по крону")

        options, args = optparser.parse_args()

        handler = get_current_file_run_log_handler(capture_stdstreams=not options.verbose)

        if options.cron_run:
            log_key = get_cron_log_key('cron_switch_bases_{}'.format(os.path.basename(handler.stream.name)))
            file_wrapper = get_wrapper_creator(FileType.CRON_RUNS, key=log_key).get_file_wrapper(handler.stream.name)

            with ObjWrapperSyncer(file_wrapper, interval=settings.MDS_LOG_UPLOAD_INTERVAL):
                try:
                    run_cron_daily_update(handler)

                    run_switch_bases(options, handler)
                except Exception:
                    log.exception('switch_bases failed')
                    raise
        else:
            run_switch_bases(options, handler)
