# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from common.data_api.file_wrapper.config import get_wrapper_creator
from travel.rasp.admin.scripts.utils.file_wrapper.registry import FileType, FILE_DIR_PATH, FILE_PATH


log = logging.getLogger(__name__)


def upload_rasp_root():
    log.info('Загружаем Rasp Root')
    dir_wrapper = get_wrapper_creator(FileType.MEDIA_RASP_ROOT).get_file_wrapper(FILE_DIR_PATH[FileType.MEDIA_RASP_ROOT])
    dir_wrapper.upload()
    log.info('Загрузили Rasp Root')


def copy_obj_between_instances(file_path, download_type, upload_type):
    # download service
    obj_wrapper = get_wrapper_creator(download_type).get_file_wrapper(file_path)
    obj_wrapper.download()
    # upload work
    obj_wrapper = get_wrapper_creator(upload_type).get_file_wrapper(file_path)
    obj_wrapper.upload()


def copy_export_data():
    # скопировать публичные экспортные данные
    log.info("Copying public export")
    copy_obj_between_instances(FILE_PATH[FileType.STATION_XML_GZ], FileType.STATION_XML_GZ, FileType.STATION_XML_GZ_WORK)

    # RASPADMIN-793
    log.info('Copying t_types_by_geoid.json')
    copy_obj_between_instances(FILE_PATH[FileType.T_TYPES_BY_GEOID], FileType.T_TYPES_BY_GEOID, FileType.T_TYPES_BY_GEOID_WORK)

    log.info('Copying bus_station_codes.json')
    copy_obj_between_instances(FILE_PATH[FileType.BUS_STATION_CODES], FileType.BUS_STATION_CODES, FileType.BUS_STATION_CODES_WORK)


def copy_media_data():
    log.info("Copying /media/data/export")
    copy_obj_between_instances(FILE_DIR_PATH[FileType.MEDIA_DATA_EXPORT], FileType.MEDIA_DATA_EXPORT, FileType.MEDIA_DATA_EXPORT_WORK)
