#!/usr/bin/env python
# coding: utf-8
""" Выгружает список основных ниток, имеющих строки дней курсирования
"""

import travel.rasp.admin.scripts.load_project  # noqa

import logging
import os.path
import sys
import time
import traceback

from django.conf import settings
from django.db import connection

from common.utils.mysql_try_hard import mysql_try_hard
from common.utils.unicode_csv import UnicodeWriter
from common.utils.metrics import task_progress_report
from travel.rasp.admin.lib.logs import print_log_to_stdout, create_current_file_run_log, get_script_log_context, ylog_context
from travel.rasp.admin.lib.mail import mail_process


log = logging.getLogger(__name__)


def run():
    start = time.time()
    log.info(u"Export main threads: start")
    filename = os.path.join(settings.EXPORT_PATH, "export_main_threads.tsv")
    prefix = '.in_process'

    log.info(u'File %s', filename)

    @mysql_try_hard
    def get_rows():
        cursor = connection.cursor()
        query = """SELECT uid, template_text FROM www_rthread WHERE template_text != '' ORDER BY uid """
        cursor.execute(query)
        rows = cursor.fetchall()
        cursor.close()
        return rows

    export_file = open(filename + prefix, 'w')
    export_writer = UnicodeWriter(export_file, delimiter='\t')
    export_writer.writerows(get_rows())

    os.rename(filename + prefix, filename)

    log.info(u"done %f", (time.time() - start))
    log.info(u"Результат доступен по адресу /admin/files/%s", os.path.basename(filename))


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()), task_progress_report('export_main_threads'):
        from optparse import OptionParser

        parser = OptionParser(description=u'Заполнить расписания станций нитками, пересчитанными в локальное время')
        parser.add_option("-v", "--verbose", dest="verbose", action="store_true")

        (options, args) = parser.parse_args()

        if options.verbose:
            print_log_to_stdout()

        create_current_file_run_log()

        message = 'export_main_threads:\n'
        try:
            run()
            message += 'finished successfully'

        except Exception as e:
            message += 'failed\n\n'
            message += str(e)
            message += '\n'.join(traceback.format_exception(*(sys.exc_info())))

        mail_process(u'Main threads export', message)
