#!/usr/bin/env python
# coding: utf-8
""" Список станций """

import travel.rasp.admin.scripts.load_project  # noqa

import logging
import os
import time
from gzip import open as gzip_open

from django.conf import settings

from common.data_api.file_wrapper.config import get_wrapper_creator
from common.models.geo import Station
from common.models.schedule import RTStation
from common.models.transport import TransportType
from travel.rasp.admin.lib.logs import create_current_file_run_log, get_script_log_context, ylog_context
from travel.rasp.admin.scripts.utils.file_wrapper.registry import FileType, FILE_PATH


log = logging.getLogger(__name__)


def makeXMLrec(station):
    title = station.title
    type = station.t_type_id == TransportType.PLANE_ID and u'аэропорт' or u'станция'
    majority = station.majority and station.majority.title or ""
    latitude = station.latitude
    longitude = station.longitude
    id = station.id

    return ("""
    <station>
        <title>%(title)s</title>
        <type>%(type)s</type>
        <majority>%(majority)s</majority>
        <latitude>%(latitude)s</latitude>
        <longitude>%(longitude)s</longitude>
        <id>%(id)s</id>
    </station>""" % locals()).replace('None', '').encode('utf8')


def run():
    start = time.time()

    prefix = '.in_process'
    filename = FILE_PATH[FileType.STATION_XML_GZ]

    log.info(u"Start")

    xml = gzip_open(filename + prefix, 'w')
    # xml = open(filename + PREFIX, 'w')
    xml.write('<?xml version="1.0" encoding="utf-8" ?>\n<stations>')

    for st in Station.objects.filter(t_type=TransportType.PLANE_ID, tablo_state='real',
                                     hidden=False).select_related('majority'):
        xml.write(makeXMLrec(st))

    for st in Station.objects.filter(t_type=TransportType.TRAIN_ID, majority__lt=5,
                                     hidden=False).select_related('majority'):
        # Проверяем электрички
        if RTStation.objects.filter(station=st, thread__t_type=TransportType.SUBURBAN_ID,
                                    thread__route__hidden=False).count():
            xml.write(makeXMLrec(st))

    xml.write('\n</stations>')
    xml.close()

    os.rename(filename + prefix, filename)

    file_wrapper = get_wrapper_creator(FileType.STATION_XML_GZ).get_file_wrapper(filename)
    file_wrapper.upload()

    log.info(u"done %f", (time.time() - start))


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        create_current_file_run_log()
        try:
            run()
        except Exception:
            log.exception(u"failed")
