# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import travel.rasp.admin.scripts.load_project  # noqa

import logging
from django.conf import settings

from common.data_api.sandbox.generate_livemap import generate_livemap_task_runner
from travel.rasp.admin.lib.logs import get_script_log_context, ylog_context


log = logging.getLogger(__name__)


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        import argparse

        parser = argparse.ArgumentParser()
        parser.add_argument('map_generator', choices=['train', 'bus'], help=u'Тип объектов.')
        parser.add_argument('duration', type=int, help=u'Время, на которое генерируются данные'
                            u', в минутах. Чем больше - тем медленнее работают карты.')
        args = parser.parse_args()

        log.info('Синхронно генерируем livemap')
        generate_livemap_task_runner.run(
            environment=settings.APPLIED_CONFIG,
            duration=args.duration,
            map_generator=args.map_generator
        )
