# coding: utf8
from __future__ import unicode_literals

import travel.rasp.admin.scripts.load_project  # noqa

import logging
from optparse import OptionParser

from django.db import transaction
from django.db.models import Q

from common.models.schedule import RThread
from common.models.transport import TransportType
from travel.rasp.library.python.common23.logging import create_current_file_run_log
from common.utils.progress import PercentageStatus

from travel.rasp.admin.lib.logs import add_stdout_handler, get_script_log_context, ylog_context
from travel.rasp.admin.lib.mysqlutils import MysqlModelUpdater
from travel.rasp.admin.lib.tmpfiles import clean_temp, get_tmp_dir


log = logging.getLogger(__name__)

# РЖД/ДОСС, Московский метрополитен
SUBURBAN_COMPANIES_BLACKLIST = [59181, 59942]


@clean_temp
@transaction.atomic
def fill_threads_canonical_uid():
    log.info('Начали заполнение canonical_uid ниток.')
    tmp_dir = get_tmp_dir()

    count = RThread.objects.filter(canonical_uid=None).count()
    log.info('Нужно обработать %s ниток.', count)
    status = PercentageStatus(count, log)
    with MysqlModelUpdater(RThread, tmp_dir, fields=['canonical_uid']) as thread_canonical_updater:
        for thread in (RThread.objects.filter(Q(canonical_uid='') | Q(canonical_uid__isnull=True)).only(
                'uid', 't_type_id', 'route__route_uid', 'company_id')):
            if thread.t_type_id == TransportType.SUBURBAN_ID and thread.company_id not in SUBURBAN_COMPANIES_BLACKLIST:
                thread.canonical_uid = 'R_{}'.format(thread.route.route_uid)
            else:
                thread.canonical_uid = 'T_{}'.format(thread.uid)

            thread_canonical_updater.add(thread)
            status.step()

    log.info('Успешно завершили заполнение canonical_uid ниток.')


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        create_current_file_run_log()

        optparser = OptionParser()
        optparser.add_option('-v', '--verbose', action='store_true')
        options, args = optparser.parse_args()

        if options.verbose:
            add_stdout_handler(log)

        fill_threads_canonical_uid()
