#!/usr/bin/env python
# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

import logging

from common.utils.metrics import task_progress_report
from travel.rasp.admin.lib.logs import create_current_file_run_log, get_script_log_context, ylog_context
from travel.rasp.admin.lib.maintenance.deploy import finalize_deploy, DeployException
from travel.rasp.admin.scripts.utils.lock import get_script_lock

log = logging.getLogger(__name__)


if __name__ == '__main__':
    with get_script_lock(), \
            ylog_context(**get_script_log_context()), task_progress_report('finalize_deploy'):
        create_current_file_run_log()

        try:
            finalize_deploy()
        except DeployException as e:
            log.error(u'Ошибка финализации выкладки. ' + e.msg_template, *e.msg_args)
        except Exception:
            log.exception(u'Ошибка финализации выкладки.')
