# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

import logging
import argparse

from django.db import connection

from travel.rasp.admin.lib.logs import print_log_to_stdout, create_current_file_run_log, get_script_log_context, ylog_context


log = logging.getLogger(__name__)

SELECT_CHANGED_BASE_STATION_PACKAGE = '''
SELECT DISTINCT
    p.id as package_id,
    s.id as station_id,
    p.last_import_datetime as package_dt,
    s.is_base_modified_at as station_dt,
    s.title as station_title,
    p.title as package_title
FROM
    www_rtstation as rts
    JOIN www_station as s ON rts.station_id = s.id
    JOIN www_rthread as t ON rts.thread_id = t.id
    JOIN www_route as r ON t.route_id = r.id
    JOIN importinfo_twostagebusimportpackage as p ON r.two_stage_package_id = p.id
    JOIN importinfo_tsithreadsetting as settings ON settings.package_id = p.id
WHERE
    settings.apply_base_stations
    AND (s.is_base OR s.is_base_modified_at IS NOT NULL)
    AND (
        p.last_import_datetime < s.is_base_modified_at
        OR (p.last_import_datetime IS NULL AND s.is_base_modified_at IS NOT NULL)
    )
ORDER BY p.id'''


SELECT_CHANGED_BASE_STATION_RED_PACKAGE = '''
SELECT DISTINCT
    p.id as package_id,
    s.id as station_id,
    p.last_import_datetime as package_dt,
    s.is_base_modified_at as station_dt,
    s.title as station_title,
    p.title as package_title
FROM
    www_rtstation as rts
    JOIN www_station as s ON rts.station_id = s.id
    JOIN www_rthread as t ON rts.thread_id = t.id
    JOIN www_route as r ON t.route_id = r.id
    JOIN red_metaroute as m ON r.red_metaroute_id = m.id
    JOIN red_package as p ON m.package_id = p.id
WHERE
    m.apply_base_stations
    AND (s.is_base OR s.is_base_modified_at IS NOT NULL)
    AND (
        p.last_import_datetime < s.is_base_modified_at
        OR (p.last_import_datetime IS NULL AND s.is_base_modified_at IS NOT NULL)
    )
ORDER BY p.id'''


def dictfetchall(cursor):
    """Returns all rows from a cursor as a dict"""
    desc = cursor.description
    return [
        dict(zip([col[0] for col in desc], row))
        for row in cursor.fetchall()
    ]


def run():
    log.info(u'Ищем двухступенчатые пакеты, которые стоит переимпортировать после недавних изменений базовости станций')

    cursor = connection.cursor()

    cursor.execute(SELECT_CHANGED_BASE_STATION_PACKAGE)

    log.info(u'Нашли двухступенчатые пакеты, которые стоит переимпортировать')

    return dictfetchall(cursor)


def run_red():
    log.info(u'Ищем красные пакеты, которые стоит переимпортировать после недавних изменений базовости станций')

    cursor = connection.cursor()

    cursor.execute(SELECT_CHANGED_BASE_STATION_RED_PACKAGE)

    log.info(u'Нашли красные пакеты, которые стоит переимпортировать')

    return dictfetchall(cursor)


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        parser = argparse.ArgumentParser()

        parser.add_argument("-v", "--verbose", action="store_true", help="increase output verbosity")

        args = parser.parse_args()

        if args.verbose:
            print_log_to_stdout(log)

        create_current_file_run_log()

        data = run()
        log.info(data)

        data_red = run_red()
        log.info(data_red)
