# coding: utf-8

from __future__ import unicode_literals, print_function

from travel.rasp.admin.lib.logs import get_script_log_context, ylog_context


"""
    март 2011
    пн   вт   ср   чт   пт   сб   вс
          1    2    3    4  # 5  # 6
     7    8    9   10   11  #12  #13
    14   15   16   17   18  #19  #20
    21   22   23   24   25  #26  #27
    28   29   30   31
    ---
    апрель 2011
    пн   вт   ср   чт   пт   сб   вс
                         1    2    3
     4    5    6    7    8    9   10
    11   12   13   14   15   16   17
    18   19   20   21   22   23   24
    25   26   27   28   29   30
"""

import travel.rasp.admin.scripts.load_project  # noqa

from datetime import timedelta, datetime

from travel.rasp.admin.lib.mask_description import get_description_from_mask
from travel.rasp.admin.importinfo.triangle_import.mask_parser import TriangleMaskTemplateParser


def main(start, end, triangle_mask_text):
    today = start + timedelta(5)

    mask_parser = TriangleMaskTemplateParser(start, end, today)

    mask = mask_parser.parse_template(triangle_mask_text)

    descrition = get_description_from_mask(mask)

    print(descrition)


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        import argparse

        parse = argparse.ArgumentParser()
        parse.add_argument('start_date', help='E.g. 2016-03-01')
        parse.add_argument('end_date', help='E.g. 2016-03-31')
        parse.add_argument('triangle_mask_text', help='E.g. 137')

        args = parse.parse_args()

        start = datetime.strptime(args.start_date, '%Y-%m-%d').date()
        end = datetime.strptime(args.end_date, '%Y-%m-%d').date()

        main(start, end, args.triangle_mask_text)
