#!/usr/bin/env python
# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

import sys
import os.path

from django.core.cache import cache


script_name = os.path.basename(__file__)

usage = "Usage: python %(script_name)s key [value] [-v]" % {'script_name': script_name}


def run(key, value=None):
    if value is not None:
        cache.set(key, value)
    else:
        print cache.get(key)


# Если файл запустили из консоли парсим параметры и запускаем импорт
if __name__ == '__main__':
    error = False

    args = sys.argv[1:]

    if len(args) == 1:
        key = args[0]
        value = None
    elif len(args) == 2:
        key, value = args
    else:
        error = u"Слишком много аргументов"

    if error:
        print error
        print usage
        sys.exit(1)

    run(key, value)
