#!/usr/bin/env python2
# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

import argparse

from django.db.models import Q
from django.db import transaction

from common.models.schedule import RTStation, PlatformTranslation
from travel.rasp.admin.lib.logs import get_script_log_context, ylog_context


@transaction.atomic
def main():
    rtstations = (RTStation.objects.filter(thread__route__hidden=False)
                           .exclude(Q(platform='') | Q(platform__isnull=True)))

    existing_platforms = set(PlatformTranslation.objects.all().values_list('platform', flat=True))

    for rts in rtstations:
        platform = (rts.platform or u'').strip()

        if not platform:
            continue

        if platform in existing_platforms:
            continue

        pt = PlatformTranslation()
        pt.platform = platform
        pt.description = u'Платформа на станции {} в стране {}'.format(
            rts.station.title, rts.station.country and rts.station.country.title
        )
        pt.save()

        existing_platforms.add(platform)


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        parser = argparse.ArgumentParser()
        parser.add_argument('-v', '--verbose', action='store_true',
                            help=u'Печатать лог на экран')

        args = parser.parse_args()

        main()
