#!/usr/bin/env python2
# coding: utf-8

u"""
Скрипт обновления ключей для перевода. См. AbstractTranslate

Примеры использования:

Получить список доступных переводов для пополнения:
scripts/i18n/fill_translates.py -c list

Обновить ключи для перевода
scripts/i18n/fill_translates.py -t travel.rasp.admin.www.models.geo.DirectionTranslate

Обновить ключи для перевода для всех доступных переводов
scripts/i18n/fill_translates.py
"""

import travel.rasp.admin.scripts.load_project  # noqa

import argparse
import datetime

from django.db import models

from common.models_utils.i18n import AbstractTranslate
from travel.rasp.admin.lib.logs import get_script_log_context, ylog_context


FILTER_ALL = '*'


def get_model_key(model):
    return model.__module__ + '.' + model.__name__


def log(message):
    print datetime.datetime.now().strftime("%m/%d/%Y  %H:%M:%S") + ' ' + message


def get_models(filter):
    result = []

    for model in models.get_models():
        if (filter == FILTER_ALL or filter == get_model_key(model)) and issubclass(model, AbstractTranslate):
            result.append(model)

    return result


def update_model(model):
    model.update()


def update(filter):
    log('Start')

    models = get_models(filter)

    if not models:
        raise Exception('Not found: ' + filter)

    for model in models:
        log('Updating %s' % get_model_key(model))

        update_model(model)

    log('End')


def list_translates():
    for model in get_models(FILTER_ALL):
        print get_model_key(model)


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        parser = argparse.ArgumentParser(description=__doc__, formatter_class=argparse.RawTextHelpFormatter)

        parser.add_argument('--translate', '-t', action='store', default=FILTER_ALL, help=u'Translate class')
        parser.add_argument('--command', '-c', action='store', default='update', help=u'Command: update or list')

        args = parser.parse_args()

        if args.command == 'update':
            update(args.translate)

        elif args.command == 'list':
            list_translates()

        else:
            raise Exception("unknown command '%s'" % args.command)
