# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

import argparse

from django.db import models
from django.db import transaction

from common.models.geo import Station, StationMajority
from common.models.transport import TransportType
from common.utils.fields import CodeCharField
from common.utils.unicode_csv import UnicodeDictReader
from travel.rasp.admin.lib.logs import get_script_log_context, ylog_context


@transaction.atomic
def import_urban_stations(urban_stations_file):
    with open(urban_stations_file) as f:
        reader = UnicodeDictReader(f, delimiter=';')

        for row in reader:
            import_station(row)


def import_station(row):
    urban_id = row['id']

    try:
        Station.get_by_code('pseudo-gortrans', urban_id)
        print u"Пропустили станцию %s %s уже импортирована" % (urban_id, row['title'])
        return
    except Station.DoesNotExist:
        pass

    del row['id']
    del row['supplier_id']

    station = Station()

    for field in Station._meta.local_fields:
        if field.attname in row:
            if isinstance(field, (models.NullBooleanField, models.ForeignKey, CodeCharField, models.IntegerField,
                                  models.TimeField, models.DateTimeField, models.FloatField)):
                value = row[field.attname] or None
            else:
                value = row[field.attname]

            setattr(station, field.attname, field.to_python(value))

    station.t_type = TransportType.objects.get(code='pseudo-gortrans')
    station.majority = StationMajority.objects.get(code='not_in_search')

    station.save()
    station.set_code('pseudo-gortrans', urban_id)

    print u"Импортировали станцию %s -> %s %s" % (urban_id, station.id, station.title)


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        parser = argparse.ArgumentParser(description='Process some integers.')
        parser.add_argument('urban_file', metavar='FILE', type=str,
                            help='Urban stations.csv file')

        args = parser.parse_args()

        import_urban_stations(args.urban_file)

