# coding: utf8

import travel.rasp.admin.scripts.load_project  # noqa

import logging
import time

from common.db import maintenance
from common.utils.metrics import task_progress_report
from travel.rasp.admin.lib.logs import create_current_file_run_log, print_log_to_stdout, get_script_log_context, ylog_context
from travel.rasp.admin.scripts.utils.lock import get_script_lock

log = logging.getLogger(__name__)


def run():
    cache_tag = time.strftime('%Y-%m-%d %H:%M:%S')
    log.info(u'Ставим кештег %s', cache_tag)
    maintenance.update_conf({'cache_tag': cache_tag})


if __name__ == '__main__':
    with get_script_lock(), \
            ylog_context(**get_script_log_context()), task_progress_report('invalidate_cache'):
        import argparse

        create_current_file_run_log()

        parser = argparse.ArgumentParser()
        parser.add_argument('-v', '--verbose', action='store_true')

        args = parser.parse_args()
        if args.verbose:
            print_log_to_stdout(log)

        run()
