# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import travel.rasp.admin.scripts.load_project  # noqa

import logging
import os
from datetime import timedelta
from dateutil import parser

from common.models.schedule import RThread
from common.models.transport import TransportType
from common.models.geo import Region
from common.utils.date import RunMask
from travel.rasp.library.python.common23.date import environment
from travel.rasp.admin.lib.logs import get_script_log_context, ylog_context


log = logging.getLogger(__name__)


def main():
    template_date = parser.parse(os.environ['RASP_QUARANTINE_BUSES_TEMPLATE_DATE']).date()
    start_date = parser.parse(os.environ['RASP_QUARANTINE_BUSES_START_DATE']).date()
    finish_date = parser.parse(os.environ['RASP_QUARANTINE_BUSES_FINISH_DATE']).date()
    log.info('Moscow quarantine buses update started')
    log.info('Template date: {}, start_date: {}, finish_date: {}'.format(template_date, start_date,finish_date))

    threads = RThread.objects.filter(t_type_id=TransportType.BUS_ID)
    updated_threads_count = 0
    for thread in threads:
        path = list(thread.path.select_related('station'))

        if not path or len(path) < 2:
            log.warning('Thread has no rtstations and skipped.uid={}, title={}'.format(thread.uid, thread.L_title()))
            continue

        if (path[0].station.region_id == Region.MOSCOW_REGION_ID and
            path[-1].station.region_id == Region.MOSCOW_REGION_ID):

            mask = RunMask(thread.year_days, environment.today())
            d = start_date
            while d <= finish_date:
                mask[d] = mask[template_date]
                d += timedelta(days=1)
            thread.year_days = str(mask)

            thread.save()
            updated_threads_count += 1

            log.info('Thread updated. uid={}, title={}'.format(thread.uid, thread.L_title()))

    log.info('Script completed successfully. {} threads updates'.format(str(updated_threads_count)))


if __name__ == '__main__':
    """
    https://st.yandex-team.ru/RASPFRONT-7834
    Неделя хождения по расписанию расписания воскресенья в связи с распоряжением властей
    """
    with ylog_context(**get_script_log_context()):
        main()
