# coding: utf8
"""Скрипт еженедельного обновления сервисной базы"""
from __future__ import unicode_literals, division, print_function

import travel.rasp.admin.scripts.load_project  # noqa

import sys
import logging
from datetime import datetime
from optparse import OptionParser

from django.conf import settings
from django.db import connection, transaction

import common.data_api.sandbox.generate_geometry_resources # noqa
from common.data_api.sandbox.run_and_release_task import run_and_release_task_runner
from common.data_api.sandbox.admin_script_after_run import AdminScripts, admin_script_after_run_task_runner
from common.dynamic_settings.default import conf
from common.models.timestamp import Timestamp
from common.utils.metrics import task_progress_report
from travel.rasp.admin.lib.maintenance.flags import flags
from travel.rasp.admin.lib.maintenance.scripts import job
from travel.rasp.admin.lib.logs import print_log_to_stdout, create_current_file_run_log, get_script_log_context, ylog_context
from travel.rasp.admin.lib.mysqlutils import analyze_all_tables
from travel.rasp.admin.scripts.support_methods import run_action_list, StateSaver


log = logging.getLogger(__name__)


def prepare_all(short=False, is_continue=False, skip_min_prices=False):
    log.info('Start')

    action_list = make_action_list(
        short,
        skip_min_prices=skip_min_prices
    )

    log.info('Scripts')

    prepare_all_state_saver = StateSaver('prepare_all_status.txt')

    run_action_list(action_list, prepare_all_state_saver, log, on_error, is_continue)

    log.info('Done')


def on_error(bad_action):
    # Report
    text = u"%s failed" % bad_action
    log.error(text)
    sys.exit(1)


def prepare_all_final():
    log.info(u'Снимаем флаги пересчета у рейсов')
    with transaction.atomic():
        cursor = connection.cursor()
        cursor.execute('UPDATE www_rthread SET changed=0')
        cursor.execute('UPDATE www_rthread SET path_and_time_unchanged=0')

    analyze_all_tables(db_alias='default')

    # Записываем дату-время пересчета
    Timestamp.set('prepare_all', datetime.now())


def make_action_list(short, full=False, skip_min_prices=False):
    params = {'base_path': settings.SCRIPTS_PATH}

    warning_action = settings.SCRIPT_WARNING_ACTION

    scripts_list = [
        " --- Prepare all!!! === ",
        (True, ['python', '-W', warning_action, 'clean_empty_threads.py']),
        (True, ['python', '-W', warning_action, 'clean_or_fix_z_tables.py']),
        (True, ['python', '-W', warning_action, 'update_reversed_numbers.py']),
        'pa= www ==',
        (True, ['python', '-W', warning_action, 'www_stations.py']),
        (True, ['python', '-W', warning_action, 'www_rtstations.py']),
        (True, ['python', '-W', warning_action, 'www_settlements.py', '-v']),
        (True, ['python', '-W', warning_action, 'www_companies.py']),
        (True, ['python', '-W', warning_action, 'export/export_suburban_stations.py']),

        'pa= fill threads canonical_uid ==',
        (True, ['python', '-W', warning_action, 'fill_threads_canonical_uid.py']),

        'pa= noderoute ==',
        (True, ['python', '-W', warning_action, 'z_noderoute2.py', '-v']),

        'pa= direction bind ==',
        (True, ['python', '-W', warning_action, 'direction_bind.py']),

        'pa= station_schedule ==',
        (True, ['python', '-W', warning_action, 'z_station_schedule.py']),

        'pa= station_view_types ==',
        (True, ['python', '-W', warning_action, 'station_view_types.py']),  # Зависит от результатов z_station_schedule
        (True, ['python', '-W', warning_action, 'settlement_view_types.py']),

        'pa= stops ==',
        (True, ['python', '-W', warning_action, 'suburban_stops.py']),

        'pa= update calc suburban keys ==',
        (False, ['python', '-W', warning_action, 'suburban_events/calc_suburban_keys.py']),

        'pa= fill train purchase numbers ==',
        (False, ['python', '-W', warning_action, 'fill_train_purchase_numbers.py']),

        'pa= run sandbox hook',
        (False, start_sandbox_after_run_task)
    ]

    if not short:
        scripts_list += [
            'pa= refill_suggest ==',
            (True, ['python', '-W', warning_action, 'refill_suggests.py']),

            'pa= railway and pathfinder ==',
            (False, generate_pathfinder_data_and_geometry),

            'pa= inflections ==',
            (False, ['python', '-W', warning_action, 'www_inflect_in_from_to.py']),

            'pa= suburban exports ==',
            (False, ['python', '-W', warning_action, 'export/export_suburban_cities.py']),
            (False, ['python', '-W', warning_action, 'export/export_stations_list.py']),

            'pa= precalc tariffs ==',
            (False, ['python', '-W', warning_action, 'precalc_tariffs.py']),

            'pa= name search index ==',
            (True, ['python', '-W', warning_action, 'build_namesearchindex.py', '--truncate']),

            'pa= rebuild_route_index',
            (True, ['python', '-W', warning_action, 'rebuild_route_index.py']),
        ]

    scripts_list += [(True, prepare_all_final), " --- End prepare all === "]

    action_list = [(params, scripts_list)]

    return action_list


def generate_pathfinder_data_and_geometry():
    if not conf.ENABLE_GENERATE_GEOMETRY_TASK:
        log.info('Не обновляем данные для пересадочника и геометрию')
        return

    log.info("Ассинхронно генерируем и обновляем данные для пересадочника и геометрию")
    environment = settings.APPLIED_CONFIG
    run_and_release_task_runner.run(
        task_name='RaspGenerateGeometryTask',
        task_path='sandbox.projects.rasp.rasp_scripts.GenerateGeometry',
        task_params={
            'env_type': environment,
            'update_env_type': environment,  # qloud
            'db_type': settings.INSTANCE_ROLE.code,
            'binary_executor_release_type': settings.SANDBOX_BINARY_RELEASE_TYPE
        },
        environment=settings.APPLIED_CONFIG
    )


def start_sandbox_after_run_task():
    admin_script_after_run_task_runner.run(AdminScripts.PREPARE_ALL)


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        create_current_file_run_log()

        optparser = OptionParser()

        optparser.add_option('-v', '--verbose', action="store_true",
                             help='выводить лог на экран')
        optparser.add_option('--standalone', action="store_true",
                             help='проверять и поднимать флаг при запуске')
        optparser.add_option("--partial", action="store_true",
                             help='поднять флаг частичного пересчета')
        optparser.add_option("--continue", dest="is_continue", action="store_true",
                             help='продолжить выпольнения с последнего шага')
        optparser.add_option("--short", action="store_true",
                             help='быстрый пересчет')
        optparser.add_option('--skip-min-prices', action='store_true',
                             help=('быстрый пересчет без минимальных цен'
                                   '[Deprecated: у нас больше нет скриптов минимальных цен]'))

        options, args = optparser.parse_args()

        if options.verbose:
            print_log_to_stdout()

        standalone = options.standalone
        partial = options.partial
        short = options.short
        is_continue = options.is_continue

        with task_progress_report('prepare_all_short' if short else 'prepare_all'):
            # Сохраняем состояние
            old_flag = flags['partial_preparation']

            if partial:
                flags['partial_preparation'] = True

            if standalone:
                if flags['maintenance']:
                    log.warning(u"Идет работа с базой, нельзя запускать prepare_all")
                    sys.exit(0)

                flags['maintenance'] = job.PREPARE_ALL.flag_value

            prepare_all(
                short=short,
                is_continue=is_continue
            )

            if partial:
                flags['partial_preparation'] = old_flag

            if standalone:
                flags['maintenance'] = 0
