# coding: utf-8
""" Заполнение таблицы саггестов """

import travel.rasp.admin.scripts.load_project  # noqa

import logging
import time as os_time

from django.db import connection, transaction

from travel.rasp.admin.lib import tmpfiles
from travel.rasp.admin.lib.logs import print_log_to_stdout, get_script_log_context, ylog_context
from travel.rasp.admin.lib.mysqlutils import MysqlFileWriter
from travel.rasp.admin.www.models.precalc import Suggest


log = logging.getLogger(__name__)


@tmpfiles.clean_temp
@transaction.atomic
def run():
    t_start = os_time.time()
    log.info(u'Refill suggests')

    tmp_file_name = tmpfiles.get_tmp_filepath('suggests.tsv')

    fields = (
        'zone_id', 'country_id', 'object_id', 'majority',
        'ttype', 'type', 'region_id',

        'title',
        'title_ru', 'full_title_ru',
        'title_uk', 'full_title_uk',
        'title_tr', 'full_title_tr',
        'title_en', 'full_title_en',
    )

    with open(tmp_file_name, 'w') as tmp_file:
        mysql_file_writer = MysqlFileWriter(tmp_file, fields=fields)

        for ttype in ('plane', 'train', 'bus', 'suburban'):
            for rowdict in Suggest.get_ttype_suggests(ttype):
                mysql_file_writer.writedict(rowdict)

        for rowdict in Suggest.get_airports_suggests():
            mysql_file_writer.writedict(rowdict)

        for rowdict in Suggest.get_water_suggests():
            mysql_file_writer.writedict(rowdict)

        for rowdict in Suggest.get_iata_city_plane_suggests():
            mysql_file_writer.writedict(rowdict)

        for rowdict in Suggest.get_plane_synonym_suggests():
            mysql_file_writer.writedict(rowdict)

    log.info(u'Loading data into table...')

    Suggest._default_manager.all().delete()

    cursor = connection.cursor()

    cursor.execute('''
    LOAD DATA LOCAL INFILE %s REPLACE INTO TABLE www_suggest
            CHARACTER SET utf8 FIELDS OPTIONALLY ENCLOSED BY '"'

    (
        {}
    )'''.format(', '.join(fields)), [tmp_file_name, ])

    log.info(u'Done in %s sec.', int(os_time.time() - t_start))


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        print_log_to_stdout()

        run()
