#!/usr/bin/env python
# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

import logging
import urllib2
from datetime import datetime
from optparse import OptionParser
from urllib import urlencode

from django.conf import settings
from django.db import transaction
from lxml import etree
from lxml.etree import XMLSyntaxError

from common.utils.exceptions import SimpleUnicodeException
from common.utils.http import urlopen
from travel.rasp.admin.lib.logs import print_log_to_stdout, create_current_file_run_log, get_script_log_context, ylog_context
from order.models import Partner


log = logging.getLogger(__name__)


def request_data(method, params={}):
    url = 'http://%(host)s:%(port)s/%(method)s?serviceId=%(service_id)s&%(params)s' % {
        'host': settings.BILLING_HOST,
        'port': settings.BILLING_PORT,
        'method': method,
        'service_id': settings.BILLING_SERVICE_ID,
        'params': urlencode(params)
    }
    try:
        response = urlopen(url, timeout=30)  # 30 cекунд
    except urllib2.URLError as e:
        log.error(u'Ошибка HTTP при получении данных %s' % unicode(e))
        raise

    return response.read()


def refresh_balance():
    data = request_data('getCampaignsWithBalanceInRange', {'fromBalance': '-99999999', 'toBalance': '99999999'})

    try:
        tree = etree.fromstring(data)
        collection = tree.find('collection')

        if collection is None:
            raise Exception('getCampaignsWithBalanceInRange %s' % etree.tostring(tree))

        for campaign in collection.xpath('campaign-balance-info'):
            datasource_id = int(campaign.find('datasource-id').text)
            balance = float(campaign.find('actual-balance').text)

            try:
                partner = Partner.find_by_billing_datasource_id(datasource_id)
                partner.current_balance = float(balance) / 100
                partner.balance_updated_at = datetime.now()
                partner.save()

                log.info(u'Успешно обновили баланс партнеру %s' % partner.title)
            except Partner.DoesNotExist:
                log.warning(u'Не смогли найти партнера с ID биллинга #%s' % datasource_id)
                continue

    except XMLSyntaxError:
        raise SimpleUnicodeException(u'Ошибка разбора данных')


def refresh_cutoffs():
    data = request_data('getCuttedoffDatasources')
    try:
        tree = etree.fromstring(data)
        collection = tree.find('collection')

        if collection is None:
            raise Exception('getCuttedoffDatasources %s' % etree.tostring(tree))

        for p in Partner.objects.all():
            p.disabled = False
            p.save()

        for datasource_id_tag in collection.xpath('datasource/datasource-id'):
            datasource_id = int(datasource_id_tag.text)
            try:
                partner = Partner.find_by_billing_datasource_id(datasource_id)
                partner.disabled = True
                partner.save()

                log.info(u'Отключили партнера %s' % partner.title)
            except Partner.DoesNotExist:
                log.warning(u'Не смогли найти партнера с ID биллинга #%s' % datasource_id)
                continue

    except XMLSyntaxError:
        raise SimpleUnicodeException(u'Ошибка разбора данных')


@transaction.atomic
def update_partners():
    log.info(u'Скачиваем баланс партнеров из коробки')
    refresh_balance()

    log.info(u'Проверяем отключения партнеров')
    refresh_cutoffs()


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        create_current_file_run_log()

        parser = OptionParser()
        parser.add_option('-v', '--verbose', dest='verbose', action="store_true")

        (options, args) = parser.parse_args()

        if options.verbose:
            print_log_to_stdout(log)

        try:
            update_partners()

        except Exception as e:
            log.exception(e.message)
