#!/usr/bin/env python
# -*- coding: utf-8 -*-

import travel.rasp.admin.scripts.load_project  # noqa @UnusedImport


import logging
import time as os_time
from datetime import date, timedelta
from optparse import OptionParser

from django.db import connection, transaction

from common.models.schedule import Route, RThread, TrainSchedulePlan
from travel.rasp.admin.lib.logs import print_log_to_stdout, create_current_file_run_log, get_script_log_context, ylog_context
from travel.rasp.admin.www.utils.mysql import correct_z_tables, fast_delete_routes, fast_delete_threads


log = logging.getLogger(__name__)


@transaction.atomic
def remove_obsolete_af_schedule():
    start = os_time.time()

    log.info(u'Удаляем рейсы старых графиков от af')

    obsolete_schedules = []
    for schedule in TrainSchedulePlan.objects.all():
        if schedule.end_date + timedelta(7) < date.today():
            obsolete_schedules.append(schedule)

    if not obsolete_schedules:
        log.info(u'Не нашли старых графиков от af')
        return

    thread_qs = RThread.objects.filter(supplier__code='af', route__script_protected=False,
                                       schedule_plan__in=obsolete_schedules)

    route_ids = list(set(thread_qs.values_list('route_id', flat=True)))

    fast_delete_threads(thread_qs, log)
    fast_delete_routes(Route.objects.filter(pk__in=route_ids, script_protected=False, rthread__isnull=True), log)

    log.info(u'correct_z_tables')
    correct_z_tables(connection.cursor())

    for schedule_plan in obsolete_schedules:
        if RThread.objects.filter(schedule_plan=schedule_plan).exists():
            continue

        log.info(u'Удаляем график хождения %s', schedule_plan.title)

    log.info(u'Маршруты старых графиков успешно удалены за %f', os_time.time() - start)


usage = u"Usage: python %prog [options]"

if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        create_current_file_run_log()

        optparser = OptionParser(usage=usage, description=__doc__)
        optparser.add_option('-v', '--verbose', action="store_true", help=u"выводить лог на экран")
        options, args = optparser.parse_args()

        if options.verbose:
            print_log_to_stdout()

        remove_obsolete_af_schedule()
