# coding: utf-8

from __future__ import absolute_import, unicode_literals

import logging

from django.db import transaction

from travel.rasp.admin.scripts.schedule.af_processors.suburban.changemode_add import apply_changemode_add
from travel.rasp.admin.scripts.schedule.af_processors.suburban.changemode_cancel import apply_changemode_cancel
from travel.rasp.admin.scripts.schedule.af_processors.suburban.changemode_change import apply_changemode_change
from travel.rasp.admin.scripts.schedule.af_processors.suburban.changemode_change_daystr import apply_changemode_change_daystr
from travel.rasp.admin.scripts.schedule.af_processors.suburban.changemode_change_facilities import apply_changemode_change_facilities
from travel.rasp.admin.scripts.schedule.af_processors.suburban.changemode_change_schedule_plan import apply_changemode_change_schedule_plan
from travel.rasp.admin.scripts.schedule.af_processors.suburban.changemode_change_weektemplate import apply_changemode_change_weektemplate
from travel.rasp.admin.scripts.schedule.af_processors.suburban.changemode_delay import apply_changemode_delay
from travel.rasp.admin.scripts.schedule.af_processors.suburban.changemode_delete import apply_changemode_delete
from travel.rasp.admin.scripts.schedule.af_processors.suburban.changemode_insert import apply_changemode_insert
from travel.rasp.admin.scripts.schedule.af_processors.suburban.changemode_refill_calendar import apply_changemode_refill_calendar
from travel.rasp.admin.scripts.schedule.af_processors.suburban.changemode_replace import apply_changemode_replace
from travel.rasp.admin.scripts.schedule.af_processors.suburban.changemode_restore import apply_changemode_restore
from travel.rasp.admin.scripts.schedule.af_processors.suburban.changemode_rewrite_facilities import apply_changemode_rewrite_facilities
from travel.rasp.admin.scripts.schedule.af_processors.suburban.exceptions import AfSuburbanProcessorError


log = logging.getLogger(__name__)


apply_changemode_funcs = {
    'insert': apply_changemode_insert,
    'cancel': apply_changemode_cancel,
    'change': apply_changemode_change,
    'delete': apply_changemode_delete,
    'add': apply_changemode_add,
    'replace': apply_changemode_replace,
    'change_schedule_plan': apply_changemode_change_schedule_plan,
    'change_daystr': apply_changemode_change_daystr,
    'restore': apply_changemode_restore,
    'change_weektemplate': apply_changemode_change_weektemplate,
    'refill_calendar': apply_changemode_refill_calendar,
    'rewrite_facilities': apply_changemode_rewrite_facilities,
    'change_facilities': apply_changemode_change_facilities,
    'delay': apply_changemode_delay,
}


@transaction.atomic
def process_thread(thread, thread_el, filename, today, bad_suburban_routes=None, recount_schedule_on_the_fly=False):
    apply_changemode_func = apply_changemode_funcs.get(thread.changemode)

    if not apply_changemode_func:
        log.error('Unknown changemode "%s"', thread.changemode)

    else:
        try:
            apply_changemode_func(
                thread=thread,
                thread_el=thread_el,
                today=today,
                bad_suburban_routes=bad_suburban_routes,
                filename=filename,
                recount_schedule_on_the_fly=recount_schedule_on_the_fly,
            )
        except AfSuburbanProcessorError, e:
            log.error(unicode(e))
