# coding: utf-8

from __future__ import absolute_import

import logging

from common.models.schedule import Route, RThread, RThreadType
from common.utils.date import RunMask
from travel.rasp.admin.scripts.schedule.af_processors.common import make_route
from travel.rasp.admin.scripts.schedule.af_processors.utils import update_template_with_text
from travel.rasp.admin.scripts.support_methods import full_create_route, full_create_thread

from travel.rasp.admin.scripts.schedule.af_processors.suburban.utils import update_station_schedule, threads_isequal


log = logging.getLogger(__name__)


def apply_changemode_add(thread, thread_el, **kwargs):
    recount_schedule_on_the_fly = kwargs.pop('recount_schedule_on_the_fly', False)

    add_to_route = None

    thread.type_id = RThreadType.ASSIGNMENT_ID

    add_to_thread_uid = thread.thread_el.get('add_to', u"").strip()
    if add_to_thread_uid:
        try:
            add_to_route = RThread.objects.get(uid=add_to_thread_uid).route
        except RThread.DoesNotExist:
            log.error(u"Не нашли нитку по uid %s", add_to_thread_uid)

    if not add_to_route:
        route = make_route(thread)
        # Проверяем, есть ли уже такой route, и если есть ищем там похожую нитку
        try:
            route = Route.objects.get(route_uid=route.route_uid)
        except Route.DoesNotExist:
            full_create_route(route, log)
            return
    else:
        route = add_to_route
        log.info(u"Переопределен пополняемый рейс на %s", route.route_uid)

    # Если маршрут найдет ищем базовую нитку с таким же маршрутом и шаблоном дней курсирования
    for db_thread in route.rthread_set.filter(type_id=RThreadType.ASSIGNMENT_ID):
        if (threads_isequal(db_thread, thread) and
                db_thread.template_text == thread.template_text):
            db_thread.year_days = str(RunMask(db_thread.year_days) | thread.mask)
            db_thread.changed = True
            db_thread.save()
            update_station_schedule(db_thread, recount_schedule_on_the_fly)
            log.info(u"Пополнили нитку %s днями хождения", db_thread.uid)
            return
    # Если не нашли добавляем нитку в маршрут
    thread.route = route
    thread.changed = True

    if thread.schedule_plan_id is None:
        log.error(u"Не указан график у нитки-назначения с номером %s", thread.number)

    update_template_with_text(thread, thread.template_timezone)
    full_create_thread(thread, log)
