# -*- coding: utf-8 -*-

from __future__ import absolute_import

import logging

from common.models.schedule import RThreadType
from common.utils.date import RunMask

from travel.rasp.admin.scripts.schedule.af_processors.suburban.affected_threads_finder import get_affected_threads_by_basic_thread
from travel.rasp.admin.scripts.schedule.af_processors.suburban.utils import update_station_schedule, str_dates
from travel.rasp.admin.scripts.schedule.af_processors.utils import copy_thread


log = logging.getLogger(__name__)


def apply_changemode_cancel(thread, thread_el, today, **kwargs):
    u"""Отменяем нитку в указанные дни хождения"""

    recount_schedule_on_the_fly = kwargs.pop('recount_schedule_on_the_fly', False)

    basic_groups = get_affected_threads_by_basic_thread(thread, thread_el, today)

    # Получаем маску во временной зоне basic_thread.time_zone
    basic_thread = basic_groups.keys()[0]

    thread.time_zone = thread.time_zone or basic_thread.time_zone
    if basic_thread.time_zone != thread.time_zone:
        log.error(u'Basic thread timezone "%s" is not equal Cancel thread timezone "%s".!!Ignore this update!!',
                  basic_thread.time_zone, thread.time_zone)
        return

    thread.time_zone = basic_thread.time_zone

    affected_threads = set()

    for basic_thread in basic_groups:
        all_mask = RunMask(0)

        for db_thread, intersection in basic_groups[basic_thread]:
            db_thread.year_days = db_thread.get_mask(today).difference(intersection)
            all_mask |= intersection

            db_thread.changed = True
            db_thread.save()

            affected_threads.add(db_thread)
            log.info(u"Отменяем нитку %s %s по дням %s", db_thread.uid, db_thread.type.title,
                     str_dates(intersection.dates()))

        canceled_threads = basic_thread.thread_changes.filter(type_id=RThreadType.CANCEL_ID)

        # Если уже есть нитка отмена, просто пополним ее дни хождения
        if canceled_threads:
            canceled_thread = canceled_threads[0]
            canceled_thread.year_days = str(RunMask(canceled_thread.year_days) | all_mask)
        else:
            canceled_thread = copy_thread(basic_thread, year_days=str(all_mask),
                                          basic_thread=basic_thread, type_id=RThreadType.CANCEL_ID)

        canceled_thread.changed = True
        canceled_thread.save()
        affected_threads.add(canceled_thread)

        basic_thread.changed = True
        basic_thread.save()
        affected_threads.add(basic_thread)

        for t in affected_threads:
            update_station_schedule(t, recount_schedule_on_the_fly)

