# -*- coding: utf-8 -*-

from __future__ import absolute_import

import logging

from common.models.schedule import RThreadType
from common.utils.date import RunMask
from travel.rasp.admin.scripts.schedule.af_processors.suburban.utils.facility import clone_facilities_to_change_thread
from travel.rasp.admin.scripts.schedule.af_processors.utils import update_template_with_text
from travel.rasp.admin.scripts.support_methods import full_create_thread

from travel.rasp.admin.scripts.schedule.af_processors.suburban.affected_threads_finder import get_affected_threads_by_basic_thread
from travel.rasp.admin.scripts.schedule.af_processors.suburban.utils import update_station_schedule, str_dates, threads_isequal


log = logging.getLogger(__name__)


def apply_changemode_change(thread, thread_el, today, **kwargs):
    """
    Создаем нитку изменение или обновляем ей дни хождения, удаляя из остальных ниток
    группы (начальная станция, номер) дни хождения нитки изменения.
    @param thread:
    @param thread_el:
    """
    recount_schedule_on_the_fly = kwargs.pop('recount_schedule_on_the_fly', False)

    basic_groups = get_affected_threads_by_basic_thread(thread, thread_el, today)

    for basic_thread in basic_groups:
        if thread.time_zone != basic_thread.time_zone:
            log.error(u'У нитки изменения зона %s, а у основной нитки зона %s. '
                      u'!!Ignore this change!!', thread.time_zone,
                      basic_thread.time_zone)
            continue

        all_mask = RunMask(0)
        # Вычитаем дни хождения изменения из всех ниток, с которыми есть пересечение
        for db_thread, intersection in basic_groups[basic_thread]:
            db_thread.year_days = db_thread.get_mask(today).difference(intersection)
            all_mask |= intersection
            db_thread.changed = True
            db_thread.save()
            update_station_schedule(db_thread, recount_schedule_on_the_fly)
            log.info(u"Изменяем нитку %s %s по дням %s", db_thread.uid, db_thread.type.title,
                     str_dates(intersection.dates()))

        # Ищем нитку изменение, с которой текущая совпадает
        change_thread = next((
            db_thread
            for db_thread in basic_thread.thread_changes.filter(type_id=RThreadType.CHANGE_ID)
            if threads_isequal(db_thread, thread)
        ), None)

        # Если уже есть нитки изменение, просто пополним ее дни хождения совпадающей
        if change_thread:
            change_thread.year_days = str(RunMask(change_thread.year_days) | all_mask)
            change_thread.changed = True
            update_station_schedule(change_thread, recount_schedule_on_the_fly)
            change_thread.save()
        # Если совпадений нет создаем новую нитку изменение
        else:
            change_thread = thread
            change_thread.route = basic_thread.route
            change_thread.type_id = RThreadType.CHANGE_ID
            change_thread.year_days = str(all_mask)
            change_thread.basic_thread = basic_thread
            change_thread.tariff_type = basic_thread.tariff_type
            change_thread.changed = True

            if thread.schedule_plan_id is None:
                log.error(u"Не указан график у нитки-изменения с номером %s. Берем его из основной.", thread.number)
                change_thread.schedule_plan_id = basic_thread.schedule_plan_id

            update_template_with_text(change_thread, thread.template_timezone)

            full_create_thread(change_thread, log)
            clone_facilities_to_change_thread(basic_thread, change_thread)

        basic_thread.changed = True
        update_station_schedule(basic_thread, recount_schedule_on_the_fly)
        basic_thread.save()
