# -*- coding: utf-8 -*-

from __future__ import absolute_import

import logging

from common.models.schedule import RThread

from travel.rasp.admin.scripts.schedule.af_processors.suburban.utils import update_station_schedule


log = logging.getLogger(__name__)


def apply_changemode_change_daystr(thread, thread_el, **kwargs):
    recount_schedule_on_the_fly = kwargs.pop('recount_schedule_on_the_fly', False)

    template_text = thread.template_text
    try:
        thread = RThread.objects.get(uid=thread.uid)
    except RThread.DoesNotExist:
        log.error(u"Не нашли нитку по uid %s", thread.uid)
        return

    thread.template_text = template_text
    thread.changed = True
    thread.save()
    update_station_schedule(thread, recount_schedule_on_the_fly)
    log.info(u"Поставили нитке %s строку дней хождения %s",
             thread.uid, thread.template_text)
