# -*- coding: utf-8 -*-

from __future__ import absolute_import

import logging

from common.models.schedule import RThread
from common.utils.date import RunMask

from travel.rasp.admin.scripts.schedule.af_processors.suburban.utils import update_station_schedule


log = logging.getLogger(__name__)


def apply_changemode_change_schedule_plan(thread, thread_el, today, **kwargs):
    recount_schedule_on_the_fly = kwargs.pop('recount_schedule_on_the_fly', False)

    schedule_plan = thread.schedule_plan
    try:
        thread = RThread.objects.get(uid=thread.uid)
    except RThread.DoesNotExist:
        log.info(u"Не нашли нитку по uid %s", thread.uid)
        return

    schedule_mask = RunMask.range(schedule_plan.start_date, schedule_plan.end_date, today, include_end=True)

    route = thread.route
    old_uid = route.route_uid
    thread.schedule_plan = schedule_plan
    thread.save()
    route.route_uid = thread.gen_route_uid(use_start_station=True)
    route.save()
    for thread in route.rthread_set.all():
        mask = RunMask(thread.year_days) & schedule_mask
        if not mask:
            log.warning(u"Получили пустые дни хождения для нитки %s", thread.uid)
        thread.year_days = str(mask)
        thread.gen_uid()
        thread.changed = True
        thread.save()
        update_station_schedule(thread, recount_schedule_on_the_fly)

    log.info(u"Поменяли граффик хождения маршруту %s -> %s",
             old_uid, route.route_uid)
