# -*- coding: utf-8 -*-

from __future__ import absolute_import

import logging

from travel.rasp.admin.scripts.schedule.af_processors.utils import update_template_with_text
from common.models.schedule import RThread

from travel.rasp.admin.scripts.schedule.af_processors.suburban.utils import update_station_schedule


log = logging.getLogger(__name__)


def apply_changemode_change_weektemplate(thread, thread_el, **kwargs):
    recount_schedule_on_the_fly = kwargs.pop('recount_schedule_on_the_fly', False)

    try:
        db_thread = RThread.objects.get(uid=thread.uid)
    except RThread.DoesNotExist:
        log.info(u"Не нашли нитку по uid %s", thread.uid)
        return

    if db_thread.time_zone != thread.template_timezone:
        log.error(u'Database thread timezone "%s" is not equal template timezone "%s". !!Ignore this update!!',
                  db_thread.time_zone, thread.template_timezone)
        return

    if 'weektemplate' in thread_el.attrib:
        db_thread.template_code = thread.template_code

    if 'weektemplate_start' in thread_el.attrib:
        db_thread.template_start = thread.template_start

    if 'weektemplate_end' in thread_el.attrib:
        db_thread.template_end = thread.template_end

    update_template_with_text(db_thread)

    db_thread.changed = True
    db_thread.save()
    update_station_schedule(db_thread, recount_schedule_on_the_fly)
    log.info(u"Поставили нитке %s строку дней хождения %s с %s по %s",
             db_thread.uid, db_thread.template_code, db_thread.template_start, db_thread.template_end)
