# -*- coding: utf-8 -*-

from __future__ import absolute_import

import logging

from common.models.schedule import RThread
from common.utils.date import RunMask
from travel.rasp.admin.scripts.schedule.af_processors.utils import update_template_with_text

from travel.rasp.admin.scripts.schedule.af_processors.suburban.utils import update_station_schedule


log = logging.getLogger(__name__)


def apply_changemode_delete(thread, thread_el, today, **kwargs):
    recount_schedule_on_the_fly = kwargs.pop('recount_schedule_on_the_fly', False)

    period_start = thread.period_start
    uid = thread.uid

    try:
        db_thread = RThread.objects.get(uid=uid)
    except RThread.DoesNotExist:
        log.error(u"Не нашли нитки по uid %s", uid)
        return

    thread.time_zone = thread.time_zone or db_thread.time_zone

    if db_thread.time_zone != thread.time_zone:
        log.error(u'Database thread timezone "%s" is not equal Delete thread timezone "%s".!!Ignore this update!!',
                  db_thread.time_zone, thread.time_zone)
        return

    mask = RunMask(db_thread.year_days, today=today)
    new_mask = RunMask()
    for d in mask.dates():
        if d < period_start:
            new_mask[d] = True

    if thread.template_end:
        db_thread.template_end = thread.template_end

        update_template_with_text(db_thread)

    db_thread.year_days = str(new_mask)
    db_thread.changed = True
    db_thread.save()
    update_station_schedule(db_thread, recount_schedule_on_the_fly)
    log.info(u"Обнулили дни хождения нитки %s начиная с %s по Москве",
             uid, period_start)
