# -*- coding: utf-8 -*-

from __future__ import absolute_import

import logging

from common.models.schedule import Route, RThreadType
from common.utils.date import RunMask
from travel.rasp.admin.scripts.support_methods import full_create_route, full_create_thread

from travel.rasp.admin.scripts.schedule.af_processors.suburban.utils import threads_isequal, update_station_schedule
from travel.rasp.admin.scripts.schedule.af_processors.common import make_route, check_route
from travel.rasp.admin.scripts.schedule.af_processors.utils import update_template_with_text


log = logging.getLogger(__name__)


def apply_changemode_insert(thread, filename, today, bad_suburban_routes=None, **kwargs):
    recount_schedule_on_the_fly = kwargs.pop('recount_schedule_on_the_fly', False)

    route = thread and make_route(thread)

    check_route(route, filename)

    try:
        route = Route.objects.get(route_uid=route.route_uid)
    except Route.DoesNotExist:
        pass

    update_template_with_text(thread, thread.template_timezone)

    if route.id:
        log.warning(u"Маршрут %s уже добавлен", route.route_uid)

        equal_thread = None
        # Если маршрут найден ищем базовую нитку с таким же маршрутом и шаблоном дней курсирования
        for db_thread in route.rthread_set.filter(type_id=RThreadType.BASIC_ID):
            if not threads_isequal(thread, db_thread):
                continue

            equal_thread = db_thread
            log.info(u'В базе уже есть похожая нитка, с другим шаблоном или периодом действия %s',
                     equal_thread.uid)

            if template_is_equal(thread, db_thread):
                db_thread.year_days = str(RunMask(db_thread.year_days) | thread.mask)
                db_thread.changed = True
                db_thread.save()
                update_station_schedule(db_thread, recount_schedule_on_the_fly)
                log.info(u"Пополнили нитку %s днями хождения", db_thread.uid)
                return

        # Если не нашли добавляем нитку в маршрут
        thread.route = route

        if thread.schedule_plan_id is None:
            log.error(u"Не указан график у нитки с номером %s", thread.number)

        thread = full_create_thread(thread, log)
        update_station_schedule(thread, recount_schedule_on_the_fly)
    else:
        route = full_create_route(route, log)

        for thread in route.rthread_set.all():
            update_station_schedule(thread, recount_schedule_on_the_fly)

    if bad_suburban_routes is not None:
        # FIXME может bad_suburban_routes.extend?
        bad_suburban_routes += check_for_mask_intersections(route, today)


def check_for_mask_intersections(route, today):
    intersection_messages = []

    threads = route.rthread_set.all().select_related('route')

    def fill_run_mask(t):
        t.run_mask = RunMask(t.year_days, today)

    map(fill_run_mask, threads)

    for index, thread in enumerate(threads):
        for next_index in range(index + 1, len(threads)):
            next_thread = threads[next_index]
            and_mask = thread.run_mask & next_thread.run_mask
            if and_mask:
                days = u",".join(map(lambda x: unicode(x), and_mask.dates()))
                message = u"У нитки %s дни хождения совпадют с ниткой %s по датам %s" % \
                    (thread.uid, next_thread.uid, days)
                log.error(message)
                intersection_messages.append(message)

    return intersection_messages


def template_is_equal(thread, db_thread):
    return (
        db_thread.template_text == thread.template_text and
        db_thread.template_code == thread.template_code and
        db_thread.template_start == thread.template_start and
        db_thread.template_end == thread.template_end
    )
