# coding: utf-8

from __future__ import absolute_import

import logging

from common.models.geo import Country
from common.models.schedule import RThread
from common.utils.date import RunMask
from travel.rasp.admin.lib.mask_builder.afmask_builders import AfMaskBuilder
from travel.rasp.admin.lib.mask_builder.ycal_builders import CountryRequiredError
from travel.rasp.admin.scripts.schedule.af_processors.af_multiparam_mask_parser import compute_bounds
from travel.rasp.admin.scripts.schedule.af_processors.suburban.utils import update_station_schedule


log = logging.getLogger(__name__)


def apply_changemode_refill_calendar(thread, thread_el, today, **kwargs):
    recount_schedule_on_the_fly = kwargs.pop('recount_schedule_on_the_fly', False)

    try:
        db_thread = RThread.objects.get(uid=thread.uid)
    except RThread.DoesNotExist:
        log.info(u'Thread was not found by uid %s', thread.uid)
        return

    if db_thread.template_code in (u'C', u'С') or not db_thread.template_code:
        log.error(u'Weektemplate is "%s". Can\'t refill calendar', db_thread.template_code)
        return

    bounds = compute_bounds(thread_el, thread.schedule_plan)
    refill_in_range_mask = RunMask.range(bounds.start_date, bounds.end_date, include_end=True)

    mask = db_thread.get_mask(today=today)

    if not mask & refill_in_range_mask:
        log.error(u'Thread year days have no intersection with provided period_start...period_end range.')
        return

    mask -= refill_in_range_mask

    calendar_geobase_country_id = thread_el.get('calendar_geobase_country_id')
    if calendar_geobase_country_id:
        country = Country.objects.get(_geo_id=calendar_geobase_country_id)
    else:
        country = None

    af_mask_builder = AfMaskBuilder()

    if not af_mask_builder.is_af_mask_text(db_thread.template_code):
        log.error(u'Can\'t parse template "%s"', db_thread.template_code)
        return

    bounds = bounds.get_narrowed(db_thread.template_start, db_thread.template_end)

    try:
        new_mask = af_mask_builder.build(bounds, db_thread.template_code, country=country, today=today)
    except CountryRequiredError:
        log.error(u'Для разбора маски "%s" необходимо указать страну', db_thread.template_code)
        return

    mask |= new_mask

    for change_thread in db_thread.thread_changes.all():
        for day in change_thread.get_mask(today=today).dates():
            if bounds.start_date <= day <= bounds.end_date:
                mask[day] = False

    db_thread.year_days = str(mask)
    db_thread.save()

    update_station_schedule(db_thread, recount_schedule_on_the_fly)
    log.info(u'Calendar was refilled in thread "%s"', db_thread.uid)
