# -*- coding: utf-8 -*-

from __future__ import absolute_import

import logging

from common.models.schedule import Route, RThread, RThreadType
from travel.rasp.admin.scripts.schedule.af_processors.common import make_route
from travel.rasp.admin.scripts.schedule.af_processors.utils import update_template_with_text
from travel.rasp.admin.scripts.schedule.utils.route_loader import CompactThreadNumberBuilder
from travel.rasp.admin.scripts.support_methods import full_create_route, full_create_thread

from travel.rasp.admin.scripts.schedule.af_processors.suburban.utils import update_station_schedule, copy_thread_attributes, path_is_equal, copy_path


log = logging.getLogger(__name__)


def apply_changemode_replace(thread, thread_el, **kwargs):
    """
    Замена старой базовой нитки на новую
    @param thread:
    @param thread_el:

    Предусмотрена только замена пути и времени старта нитки
    """
    recount_schedule_on_the_fly = kwargs.pop('recount_schedule_on_the_fly', False)

    # Оставляем в нитке все тоже самое но заменяем время старта и станции
    try:
        db_thread = RThread.objects.get(uid=thread.uid, type_id=RThreadType.BASIC_ID)
    except RThread.DoesNotExist:
        log.error(u"Не нашли основную нитку с uid %s", thread.uid)
        return

    if path_is_equal(thread, db_thread):
        log.info(u"Нитки совпали по пути, копируем путь")
        copy_path(thread, db_thread)

        db_thread.tz_start_time = thread.tz_start_time
        db_thread.changed = True
        db_thread.save()

        update_station_schedule(db_thread, recount_schedule_on_the_fly)

    else:
        log.info(u"Отвязываем изменения от старой базовой нитки")
        changes = list(db_thread.thread_changes.all())
        for change in changes:
            change.basic_thread = None
            change.save()

        log.info(u'Копируем дни хождения и шаблон из старой нитки в новую')
        thread.year_days = db_thread.year_days
        thread.template_text = db_thread.template_text

        thread.template_code = db_thread.template_code
        thread.template_start = db_thread.template_start
        thread.template_end = db_thread.template_end

        update_template_with_text(thread)
        copy_thread_attributes(thread, db_thread)

        thread.type_id = RThreadType.BASIC_ID
        thread.changed = True

        old_route = db_thread.route
        log.info(u"Удаляем нитку %s", db_thread.uid)
        db_thread.delete()

        if thread.gen_route_uid(use_start_station=True) != old_route.route_uid:
            new_route = make_route(thread)

            base_route = None
            try:
                base_route = Route.objects.get(route_uid=new_route.route_uid)
            except Route.DoesNotExist:
                pass
            # Если такой маршрут уже есть, добавим нитки туда
            if base_route:
                thread.route = base_route
                CompactThreadNumberBuilder([change.route]).build_for(thread)
                full_create_thread(thread, log)

            else:
                base_route = full_create_route(new_route, log)

            log.info(u"Привязываемcя к маршруту %s", base_route.route_uid)

            for change in changes:
                change.route = base_route
                CompactThreadNumberBuilder([change.route]).build_for(change)

        else:
            thread.route = old_route
            full_create_thread(thread, log)

        log.info(u'Переносим изменения в новую нитку')
        for change in changes:
            change.basic_thread = thread
            change.changed = True
            change.save()

            update_station_schedule(change, recount_schedule_on_the_fly)

        update_station_schedule(thread, recount_schedule_on_the_fly)

    log.info(u"Заменили нитку %s", thread.uid)
