# coding: utf-8

from __future__ import absolute_import

import logging

from common.models.schedule import RThread, RThreadType
from common.utils.date import RunMask

from travel.rasp.admin.scripts.schedule.af_processors.suburban.affected_threads_finder import get_affected_threads_by_basic_thread
from travel.rasp.admin.scripts.schedule.af_processors.suburban.utils import update_station_schedule, str_dates


log = logging.getLogger(__name__)


def apply_changemode_restore(thread, thread_el, today, **kwargs):
    """
    Восстанавливаем, отмену или изменения на все дни хождения вторичный ниток,
    @param thread:
    @param thread_el:
    """

    recount_schedule_on_the_fly = kwargs.pop('recount_schedule_on_the_fly', False)

    if thread.uid:
        try:
            secondary_thread = RThread.objects.get(uid=thread.uid)
            if not secondary_thread.basic_thread_id:
                log.error(u"Нитка %s не имеет базовой", thread.uid)
                return
            basic_thread = secondary_thread.basic_thread
            secondary_thread.year_days = str(RunMask(secondary_thread.year_days).difference(thread.mask))
            basic_thread.year_days = str(RunMask(basic_thread.year_days) | thread.mask)

            basic_thread.changed = True

            secondary_thread.changed = True

            basic_thread.save()
            update_station_schedule(basic_thread, recount_schedule_on_the_fly)
            secondary_thread.save()
            update_station_schedule(secondary_thread, recount_schedule_on_the_fly)

            log.info(u"Восстановили дни хождения у нитки %s %s",
                     basic_thread.uid, str_dates(thread.mask.dates()))
        except RThread.DoesNotExist:
            log.info(u"Не нашли нитку по uid %s", thread.uid)
    else:
        basic_groups = get_affected_threads_by_basic_thread(thread, thread_el, today)

        for basic_thread in basic_groups:
            basic_thread.mask = basic_thread.get_mask(today)

            for db_thread, intersection in basic_groups[basic_thread]:
                if db_thread.type_id in (RThreadType.CANCEL_ID, RThreadType.CHANGE_ID):
                    basic_thread.mask |= intersection

                    db_thread.year_days = str(db_thread.get_mask(today).difference(intersection))
                    db_thread.changed = True
                    db_thread.save()
                    update_station_schedule(db_thread, recount_schedule_on_the_fly)
                    log.info(u"Восстановили нитку %s %s по дням %s", basic_thread.uid,
                             basic_thread.type.title,
                             str_dates(intersection.dates()))

            basic_thread.year_days = str(basic_thread.mask)
            basic_thread.changed = True
            basic_thread.save()
            update_station_schedule(basic_thread, recount_schedule_on_the_fly)
