# coding: utf-8

from __future__ import absolute_import, unicode_literals

import logging

from django.db import transaction

from common.apps.facility.models import SuburbanThreadFacility
from common.models.schedule import RThread
from travel.rasp.library.python.common23.date import environment
from travel.rasp.admin.lib.mask_builder.ycal_builders import CountryRequiredError
from travel.rasp.admin.scripts.schedule.af_processors.af_multiparam_mask_parser import get_calendar_country
from travel.rasp.admin.scripts.schedule.af_processors.suburban.utils.facility import check_intersection
from travel.rasp.admin.scripts.schedule.af_processors.suburban.affected_threads_finder import set_mask, AffectedThreadsByBasicThreadBuilder
from travel.rasp.admin.scripts.schedule.af_processors.suburban.exceptions import AfSuburbanProcessorError
from travel.rasp.admin.scripts.schedule.af_processors.suburban.utils.facility import build_pre_facilities, clone_facilities_to_change_thread


log = logging.getLogger(__name__)


@transaction.atomic
def apply_changemode_rewrite_facilities(thread, thread_el, today, **kwargs):
    """
    Переписываем удобства нитки на новые, затем клонируем их в нитки изменения.
    """

    today = today or environment.today()

    if thread.uid:
        try:
            threads = [RThread.objects.get(uid=thread.uid)]
        except RThread.DoesNotExist:
            log.error('Не нашли нитку по uid %s', thread.uid)
            return
        set_mask(threads[0], today)
    else:
        threads = AffectedThreadsByBasicThreadBuilder(thread, thread_el, today).get_basic_threads()

    country = get_calendar_country(thread_el)

    for thread in threads:
        log.info('Перезаписываем удобства у нитки %s', thread.uid)
        try:
            pre_facilities = build_pre_facilities(thread_el, thread.schedule_plan, country, today)
        except CountryRequiredError:
            raise AfSuburbanProcessorError('Необходимо указать calendar_geobase_country_id в нитке,'
                                           ' для построения масок удобств')

        check_intersection(thread, pre_facilities, today)
        _rewrite_facilities(thread, pre_facilities)


@transaction.atomic
def _rewrite_facilities(thread, pre_facilities):
    thread.suburbanthreadfacility_set.all().delete()

    for pre_facility in pre_facilities.values():
        if pre_facility.facilities and pre_facility.mask:
            thread_facility = SuburbanThreadFacility.objects.create(thread=thread, year_days=pre_facility.mask)
            for facility in pre_facility.facilities:
                thread_facility.facilities.add(facility)

    for change_thread in thread.thread_changes.all():
        clone_facilities_to_change_thread(thread, change_thread)
