# -*- coding: utf8 -*-

from __future__ import absolute_import

import json
import logging

from common.models.schedule import RThread, Supplier
from common.utils.caching import cache_until_switch
from travel.rasp.admin.lib.exceptions import SimpleUnicodeException
from travel.rasp.admin.scripts.schedule.af_processors.af_thread_parser import AfThreadParser
from travel.rasp.admin.scripts.schedule.utils.afmasktext import shift_and_build_days_texts, AFTextBuilder
from travel.rasp.admin.scripts.support_methods import full_create_thread


log = logging.getLogger(__name__)


class BadESRCodeError(SimpleUnicodeException):
    def __init__(self, *args):
        self.args = args
        self.msg = u'Не нашли станции с кодами: '
        self.msg += u', '.join(self.args)


class AFThreadParseError(SimpleUnicodeException):
    pass


# По умолчанию компания РЖД
RZD_COMPANY_ID = 112


def parse_thread(thread_el, default_region_id=None, default_t_type_code=None):
    return AfThreadParser(
        default_region_id=default_region_id,
        default_t_type_code=default_t_type_code,
        default_company_id=RZD_COMPANY_ID,
        default_supplier=Supplier.objects.get(code='af')
    ).parse_thread(thread_el)


@cache_until_switch
def get_text_builder():
    return AFTextBuilder()


def update_template_with_text(thread, timezone=None):
    timezone = timezone or thread.time_zone
    texts = shift_and_build_days_texts(thread, template_timezone=timezone,
                                       builder=get_text_builder())

    if texts:
        thread.translated_manual_days_texts = json.dumps(texts)
    else:
        thread.translated_manual_days_texts = u''


def copy_thread(thread, **kwargs):
    new_thread = RThread.objects.get(id=thread.id)
    new_thread.id = None
    new_thread.ordinal_number = None
    new_thread.uid = None
    new_thread.import_uid = None

    for name, value in kwargs.iteritems():
        setattr(new_thread, name, value)

    new_thread.rtstations = []
    for rtstation in thread.rtstation_set.all():
        rtstation.id = None
        rtstation.thread = new_thread
        new_thread.rtstations.append(rtstation)

    return full_create_thread(new_thread, log)
