# -*- encoding: utf-8 -*-

import travel.rasp.admin.scripts.load_project  # noqa

import logging
from optparse import OptionParser
from traceback import format_exc

from django.db import transaction

from travel.rasp.admin.importinfo.models.two_stage_import import TwoStageImportPackage
from travel.rasp.admin.importinfo.two_stage_import.admin import get_package_importer, run_tsi
from travel.rasp.admin.lib.logs import create_current_file_run_log, print_log_to_stdout, get_script_log_context, ylog_context
from travel.rasp.admin.lib.mail import mail_datachanges, mail_message

log = logging.getLogger(__name__)


@transaction.atomic
def try_import_package(package):
    run_tsi('import_into_middle_base', package, set_up_flag=False)

    importer = get_package_importer(package)

    bad_stations = importer.get_unbinded_stations()

    if bad_stations:
        message = u'\n'.join(u'Соответсвий %s для %s thread=%s' %
                             (count, s, s.get_any_thread_title())
                             for s, count in bad_stations)

        mail_datachanges(u'Не верно проставлены соответствия в пакете {} {}'.format(package.id, package.title),
                         message)

        log.error(u'Не хватает привязок в пакете')

    run_tsi('import_package', package, set_up_flag=False)

    log.info(u'Успешно импортировали пакет')


def main():
    log.info(u'Запускаем еженедельный автоимпорт')
    reimport_query_set(TwoStageImportPackage.objects.filter(autoimport=True), u'Еженедельный автоимпорт')
    log.info(u'Eженедельный автоимпорт закончен')


def reimport_query_set(query_set, subject_prefix):
    log.info(u'Запускаем импорт на пакетах:')
    for package in query_set:
        log.info(u'    %s %s', package.title, package.id)

    failed = []
    success = []

    for package in query_set:
        log.info(u'Импортируем пакет %s %s', package.title, package.id)
        try:
            # заглушка, для бага в джанге
            package.package_file
            try_import_package(package)

            log.info(u'Успешно импортировали пакет %s %s', package.id, package.title)
            success.append(package)
        except Exception:
            subject = u'{}: Ошибка импорта двухступенчатого пакета {} {}'.format(
                subject_prefix, package.id, package.title)
            message = format_exc()
            mail_datachanges(subject, message)
            mail_message(subject, message, recipients=[[package.content_manager.name, package.content_manager.email]])
            log.exception(u'Ошибка импорта пакета %s %s', package.title, package.id)

            log.info(u'Завершен с ошибкой импорт пакета %s %s', package.id, package.title)
            failed.append(package)

    log.info(u'Результаты импорта:')
    for p in success:
        log.info(u'    Успешно импортировали пакет %s %s', p.id, p.title)

    for p in failed:
        log.info(u'    Завершен с ошибкой импорт пакета %s %s', p.id, p.title)

    log.info(u'Импорт пакетов завершен')


def tsi_every_day_autoimport():
    log.info(u'Запускаем ежедневный автоимпорт')
    reimport_query_set(TwoStageImportPackage.objects.filter(
        autoimport=True,
        every_day_autoimport=True
    ), u'Eжедневный автоимпорт')
    log.info(u'Eжедневный автоимпорт закончен')


usage = u'Usage: python %prog [options]'

# Если файл запустили из консоли парсим параметры и запускаем скрипт
if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        create_current_file_run_log()

        optparser = OptionParser(usage=usage, description=__doc__)
        optparser.add_option('-v', '--verbose', action='store_true',
                             help=u'выводить лог на экран')
        options, args = optparser.parse_args()

        if options.verbose:
            print_log_to_stdout()

        main()
