# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

import logging
import argparse

from travel.rasp.library.python.common23.date import environment
from common.utils.metrics import task_progress_report
from common.models.schedule import RThread
from travel.rasp.admin.lib.logs import print_log_to_stdout, create_current_file_run_log, get_script_log_context, ylog_context


log = logging.getLogger(__name__)


def run():
    today = environment.today()
    log.info(u'Проверяем отмены и изменения на пересечение с основным расписанием')

    for thread in RThread.objects.filter(type__code__in=('cancel', 'change'), route__t_type__code='suburban'):
        if not thread.basic_thread_id:
            continue

        basic_thread = thread.basic_thread

        intersection_mask = thread.get_mask(today=today) & basic_thread.get_mask(today=today)

        if intersection_mask:
            log.error(
                u'Маска нитки %s %s %s %s пересекается с основной по дням %s',
                thread.id, thread.uid, thread.title, thread.type.code,
                intersection_mask.dates(past=True)
            )

    log.info(u'Проверка завершена')


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()), task_progress_report('check_suburban_mask_intersections'):
        parser = argparse.ArgumentParser()

        parser.add_argument("-v", "--verbose", action="store_true", help="increase output verbosity")

        args = parser.parse_args()

        if args.verbose:
            print_log_to_stdout(log)

        create_current_file_run_log()

        run()
