#!/usr/bin/env python
# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

import logging
import os
import re
import time as os_time
import traceback
from datetime import date
from subprocess import Popen, PIPE, call

from bs4 import BeautifulSoup
from django.conf import settings
from django.utils.encoding import smart_str, smart_unicode

from common.models.schedule import Supplier
from travel.rasp.library.python.common23.date import environment
from travel.rasp.admin.lib import tmpfiles
from travel.rasp.admin.lib.exceptions import SimpleUnicodeException
from travel.rasp.admin.lib.fileutils import creating_dir_join
from travel.rasp.admin.lib.logs import print_log_to_stdout, create_current_file_run_log, get_current_file_logger_name, get_script_log_context, ylog_context
from travel.rasp.admin.lib.mail import mail_process
from travel.rasp.admin.scripts.schedule.tis_train.utils import FTP_URL
from travel.rasp.admin.scripts.utils.import_file_storage import get_schedule_temporary_date_filepath


log = logging.getLogger(__name__)


script_runs_log_name = 'special.script_runs.' + get_current_file_logger_name()
script_runs_log_dir = os.path.join(settings.LOG_PATH, *script_runs_log_name.split('.'))

wget_log_file = creating_dir_join(script_runs_log_dir, environment.now().strftime('wget_%Y-%m-%d_%H%M%S.log'))


def remove_not_xml_symbols(gz_xml_file):
    log.info(u"Удалим некорректные символы из файла %s", gz_xml_file)
    tmp_file = gz_xml_file + '.tmp'
    tmp_file_object = open(tmp_file, 'w')
    zcat = Popen(['gzip', '-dc', gz_xml_file], stdout=PIPE)
    sed = Popen(['sed', r's/<tr>/\n<tr>/g'], stdin=zcat.stdout, stdout=PIPE)
    sed2 = Popen(['sed', r's/>\x00</>0</g'], stdin=sed.stdout, stdout=PIPE)
    sed3 = Popen(['sed', r's/\x1a//g'], stdin=sed2.stdout, stdout=PIPE)
    gzip = Popen(['gzip'], stdin=sed3.stdout, stdout=tmp_file_object)
    ret_code = zcat.wait() or sed.wait() or sed2.wait() or sed3.wait() or gzip.wait()
    tmp_file_object.close()
    if ret_code != 0:
        raise SimpleUnicodeException(
            u'Не удалось избавиться от некореектных символов в файле {}'.format(gz_xml_file)
        )

    os.rename(tmp_file, gz_xml_file)
    log.info(u"Некорректные символы успешно удалены из файла %s", gz_xml_file)


def run():
    log.info(u"Скачиваем файла расписания от ТИС")

    download()


def download():
    try:
        try_download()

        return True

    except SimpleUnicodeException as e:
        log.exception(u'Ошибка при скачивании')
        error_message = unicode(e)

    except Exception:
        log.exception(u'Ошибка при скачивании')
        error_message = smart_str(traceback.format_exc())

    if error_message:
        mail_process(u'Ошибка при скачивании ТИС!!!', error_message)

    return False


@tmpfiles.clean_temp
def try_download():
    supplier = Supplier.objects.get(code='tis')
    start = os_time.time()

    log.info(u'Качаем %s', FTP_URL)

    wget_working_dir = tmpfiles.get_tmp_dir('wget-working-dir')

    wget = Popen(['wget', FTP_URL, '-O', '-', '--dot-style=mega', '-a', wget_log_file,
                 '--connect-timeout=3', '--tries=3'],
                 stdout=PIPE, stderr=PIPE, cwd=wget_working_dir)

    log.info(u"Получаем листинг от ТИС")
    listing = wget.stdout.read()
    wget_stderr = wget.stderr.read()
    wget.wait()

    if wget.returncode != 0:
        raise SimpleUnicodeException(u'Не удалось скачать листинг от ТИС: %s' % smart_unicode(wget_stderr))

    tree = BeautifulSoup(listing)
    filelist = []
    for a in tree.findAll('a'):
        filename = a.string
        if re.match(r'\d{4}\d{2}\d{2}\.gz', filename):
            date_ = date(*os_time.strptime(filename, '%Y%m%d.gz')[:3])
            filelist.append(dict(filename=filename, href=a['href'], date=date_))

    filelist.sort(key=lambda x: x['date'], reverse=True)
    last_file = filelist[0]
    outfile = get_schedule_temporary_date_filepath('tis_trains.xml.gz', supplier, today=last_file['date'])
    good_outfile = outfile.replace('.xml.gz', '_good.xml.gz')

    if os.path.exists(outfile) or os.path.exists(good_outfile):
        log.info(u"Файл за дату %s уже скачан", last_file['date'])
        return

    log.info(u"Качаем файл %s за дату %s", last_file['filename'], last_file['date'])

    ret_code = call(['wget', last_file['href'], '-O', outfile,
                     '--dot-style=mega', '-a', wget_log_file,
                     '--connect-timeout=3', '--tries=3'], cwd=wget_working_dir)

    if ret_code != 0:
        raise SimpleUnicodeException(u'Не получилось скачать файл {}'.format(last_file['filename']))

    log.info(u"Файл %s успешно скачан за %.2f с.", outfile, os_time.time() - start)

    remove_not_xml_symbols(outfile)


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        create_current_file_run_log()

        print_log_to_stdout(log)
        run()
