# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

import re
import os.path
import logging
from cStringIO import StringIO
from optparse import OptionParser
from xml.etree import ElementTree
from xml.parsers.expat import ExpatError

from common.models.schedule import Supplier
from common.models.transport import TransportType
from travel.rasp.library.python.common23.date import environment
from travel.rasp.admin.importinfo.models.af import AFScheduleFile
from travel.rasp.admin.lib.logs import print_log_to_stdout, create_current_file_run_log, get_script_log_context, ylog_context
from travel.rasp.admin.scripts.schedule.af_processors import common, suburban
from travel.rasp.admin.scripts.schedule.af_processors.af_thread_parser import AfThreadParser
from travel.rasp.admin.scripts.schedule.af_processors.utils import BadESRCodeError, RZD_COMPANY_ID


script_name = os.path.basename(__file__)

log = logging.getLogger(__name__)

re_filename = re.compile(ur'.*\.xml')


def import_af(t_type_code=None, add_import=False):
    log.info(u"Импортируем %s", t_type_code)

    today = environment.today()

    if add_import:
        files = AFScheduleFile.objects.filter(imported__isnull=True)
    else:
        files = AFScheduleFile.objects.all()

    bad_suburban_routes = list()

    for file_ in files:
        filename = file_.schedule_file_name
        log.info(u'Парсим файл %s %s', file_.schedule_file_name, file_.region.title)
        log.info(u"Импортируем только нитки с типом транспорта %s", t_type_code)

        af_suburban_thread_parser = AfThreadParser(default_region_id=file_.region.id,
                                                   default_t_type_code='suburban',
                                                   default_company_id=RZD_COMPANY_ID,
                                                   default_supplier=Supplier.objects.get(code='af'))
        try:
            af_tree = ElementTree.parse(StringIO(file_.get_encoded_data()))
        except ExpatError:
            log.exception(u"Не смогли распарсить файл %s %s", file_.id, file_.schedule_file_name)
            continue

        for thread_el in af_tree.findall('.//thread'):

            if thread_el.get('changemode') != "insert":
                log.error(u'Попалась нитка с changemode "%s"'
                          u' пропускаем ее при обычном импорте расписаний',
                          thread_el.get('changemode'))
                continue

            try:
                if not thread_el.get('t_type'):
                    log.error(u"Не указан тип транспорта, у нитки %s", thread_el.get('number'))
                    continue

                if thread_el.get('t_type') != t_type_code:
                    log.warning(u"Встретился неожиданный тип транспорта %s", thread_el.get('t_type'))
                    continue

                thread = af_suburban_thread_parser.parse_thread(thread_el)

                if thread is None:
                    continue

                if not thread.mask:
                    log.info(u"У нитки %s ни одного дня хождения", thread_el.get('number'))
                    continue

                if thread.t_type_id == TransportType.SUBURBAN_ID:
                    suburban.process_thread(thread, thread_el, filename, today,
                                            bad_suburban_routes)
                else:
                    common.process_thread(thread, filename)

            except BadESRCodeError, e:
                log.error(unicode(e))

        file_.imported = environment.now()
        file_.save()


usage = u"Usage: python %prog t_type [options]"
# Если файл запустили из консоли парсим параметры и запускаем импорт
if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        create_current_file_run_log()

        kwargs = {}
        optparser = OptionParser(usage=usage, description=__doc__)
        optparser.add_option('-v', '--verbose', action="store_true",
                             help=u"выводить лог на экран")
        optparser.add_option('-a', '--add-import', action="store_true",
                             help=u"делать доимпорт")
        options, args = optparser.parse_args()

        if options.verbose:
            print_log_to_stdout()

        codes = (t.code for t in TransportType.objects.all())
        if not args or args[0] not in codes:
            optparser.error("Не указан тип транспорта")

        t_type_code = args[0]

        import_af(t_type_code=t_type_code, add_import=options.add_import)
