# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

import logging
import os.path
from importlib import import_module
from optparse import OptionParser

from common.models.schedule import Supplier
from common.utils.metrics import task_progress_report
from travel.rasp.admin.lib.maintenance.flags import flags
from travel.rasp.admin.lib.maintenance.scripts import job, IMPORT_OPTIONS
from travel.rasp.admin.lib.logs import print_log_to_stdout, create_current_file_run_log, get_script_log_context, ylog_context


script_name = os.path.basename(__file__)

log = logging.getLogger(__name__)


def reimport(import_code, ignore_flag=False):
    import_options = IMPORT_OPTIONS[import_code]
    if not ignore_flag:
        if flags['maintenance']:
            log.error(u"Нелья запускать переимпорт, идет работа с базой данных")
            return
        flags['maintenance'] = job.RE_IMPORT.flag_value

    log.info(u'Запускаем переимпорт. %s', import_options['description'])

    supplier = Supplier.objects.get(code=import_options['supplier_code'])

    try:
        log.info(u"Переимпотируем маршруты от поставщика %s - %s", supplier.title, supplier.code)

        schedule_module = import_module(import_options['module'])

        can_import = True
        if hasattr(schedule_module, 'advance_checks_launcher'):
            log.info(u"Делаем предварительные проверки")
            if schedule_module.advance_checks_launcher():
                log.info(u"Проверки прошли успешно")
            else:
                log.error(u"Проверки не удались")
                can_import = False

        if can_import:
            log.info(u"Запускаем импорт от поставщика %s - %s", supplier.title, supplier.code)
            schedule_module.import_launcher(download=import_options['download'])
            log.info(u"Успешно импортировали данные от поставщика %s - %s", supplier.title, supplier.code)

    except Exception:
        log.exception(u"Не удалось совершить переимпорт от поставщика")

    if not ignore_flag:
        flags['maintenance'] = 0


# Если файл запустили из консоли парсим параметры и запускаем скрипт
if __name__ == '__main__':
    with ylog_context(**get_script_log_context()), task_progress_report('re_import'):
        create_current_file_run_log()

        usage = u"Переимпорт не запускает пересчет!!!"
        usage += u"Usage: python %prog [options] " + u"|".join(IMPORT_OPTIONS.keys())

        optparser = OptionParser(usage=usage, description=__doc__)
        optparser.add_option('-i', '--ignore-flag', action="store_true", help=u"игнорировать флаг")
        optparser.add_option('-v', '--verbose', action="store_true", help=u"выводить лог на экран")
        options, args = optparser.parse_args()

        if not args:
            optparser.error(u'Укажите один из выриантов переимпорта')

        import_code = args[0]
        if import_code not in IMPORT_OPTIONS:
            optparser.error(u'Нет такого варианта импорта в списке')

        if options.verbose:
            print_log_to_stdout()

        reimport(import_code, ignore_flag=options.ignore_flag)
