# -*- encoding: utf-8 -*-

import travel.rasp.admin.scripts.load_project  # noqa

import logging
from optparse import OptionParser
from traceback import format_exc

from django.db import transaction

from travel.rasp.admin.lib.mail import mail_datachanges
from travel.rasp.admin.lib.logs import create_current_file_run_log, print_log_to_stdout, get_script_log_context, ylog_context
from travel.rasp.admin.admin.red.models import Package
from travel.rasp.admin.admin.red.metaimport import RedPackageImporter


log = logging.getLogger(__name__)


@transaction.atomic
def try_import_package(package):
    importer = RedPackageImporter(package)

    importer.import_package()

    log.info(u"Успешно импортировали пакет %s %s", package.id, package.title)


def main():
    for package in Package.objects.filter(autoimport=True):
        log.info(u"Импортируем пакет %s %s", package.title, package.id)
        try:
            try_import_package(package)
        except Exception:
            mail_datachanges(u"Ошибка импорта красного пакета %s %s" %
                             (package.id, package.title), format_exc())
            log.exception(u"Ошибка импорта красного пакета %s %s", package.title, package.id)


usage = u"Usage: python %prog [options]"

# Если файл запустили из консоли парсим параметры и запускаем скрипт
if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        create_current_file_run_log()

        optparser = OptionParser(usage=usage, description=__doc__)
        optparser.add_option('-v', '--verbose', action="store_true",
                             help=u"выводить лог на экран")
        options, args = optparser.parse_args()

        if options.verbose:
            print_log_to_stdout()

        main()
