# coding: utf-8

import travel.rasp.admin.scripts.load_project  # noqa

import logging
import argparse

from dateutil.relativedelta import relativedelta

from travel.rasp.library.python.common23.date import environment
from travel.rasp.admin.importinfo.models.two_stage_import import PackageDirectionsSlice
from travel.rasp.admin.lib.logs import print_log_to_stdout, create_current_file_run_log, get_script_log_context, ylog_context


log = logging.getLogger(__name__)

# Бывают пакеты, где импорт идет раз в год, надо иметь возможность сравнить.
SAVE_MONTHS_IN_PAST = 14


def remove_old_slices():
    log.info(u'Удаляем старые срезы данных')

    border_dt = environment.now() - relativedelta(months=SAVE_MONTHS_IN_PAST)
    PackageDirectionsSlice.objects.filter(creation_dt__lt=border_dt).delete()

    log.info(u'Удаление старых срезов данных завершено')


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        parser = argparse.ArgumentParser()

        parser.add_argument("-v", "--verbose", action="store_true", help="increase output verbosity")

        args = parser.parse_args()

        if args.verbose:
            print_log_to_stdout(log)

        create_current_file_run_log()

        remove_old_slices()
