#!/usr/bin/env python
# coding: utf-8

import argparse

import travel.rasp.admin.scripts.load_project  # noqa

from django.db import transaction

from travel.rasp.admin.importinfo.models.two_stage_import import TwoStageImportPackage, TwoStageImportThread
from travel.rasp.admin.lib.logs import get_script_log_context, ylog_context


@transaction.atomic
def main(options):
    package = TwoStageImportPackage.objects.get(id=options.package)

    for tsi_thread in TwoStageImportThread.objects.filter(package=package):
        for tsi_ts in tsi_thread.threadstations.all():
            tsi_ts_flag = tsi_ts.station.get_fuzzy_flag(package, tsi_thread.path_key)

            update_ts_flag(tsi_ts_flag, options)


def update_ts_flag(tsi_ts_flag, options):
    for name in ('is_fuzzy', 'is_searchable_from', 'is_searchable_to',
                 'in_station_schedule', 'in_thread'):
        if getattr(options, name):
            value = str2none_bool(getattr(options, name))

            setattr(tsi_ts_flag, name, value)

    tsi_ts_flag.save()


def str2none_bool(value):
    if value == 'FALSE':
        return False

    if value == 'TRUE':
        return True

    if value == 'NULL':
        return None

    raise Exception('Illegal value')


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        parser = argparse.ArgumentParser(description='Process some integers.',
                                         formatter_class=argparse.RawTextHelpFormatter)
        parser.add_argument(
            'package', type=int, metavar='PACKAGE',
            choices=[t.id for t in TwoStageImportPackage.objects.all()],
            help=u'Номер пакета. Список пакетов:\n' + u'\n'.join(
                u'{t.id}: {t.title}'.format(t=t)
                for t in TwoStageImportPackage.objects.all()
            )
        )

        parser.add_argument('--is-fuzzy', choices=('TRUE', 'FALSE', 'NULL'), default='')
        parser.add_argument('--is-searchable-from', choices=('TRUE', 'FALSE', 'NULL'), default='')
        parser.add_argument('--is-searchable-to', choices=('TRUE', 'FALSE', 'NULL'), default='')
        parser.add_argument('--in-station-schedule', choices=('TRUE', 'FALSE', 'NULL'), default='')
        parser.add_argument('--in-thread', choices=('TRUE', 'FALSE', 'NULL'), default='')

        options = parser.parse_args()

        main(options)
