# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import re

from travel.rasp.admin.importinfo.admin import CodeshareNumber


def get_code_share_regexps():
    code_share_numbers = CodeshareNumber.objects.all()
    regexps = [re.compile(code_share.number_re, re.U) for code_share in code_share_numbers]

    return regexps


def check_code_share_number(regexps, number):
    for reg_exp in regexps:
        if reg_exp.match(number) or reg_exp.match(number.replace(' ', '')):
            return True

    return False
