# -*- coding: utf-8 -*-

from travel.rasp.admin.lib.mail import mail_process
from common.models.schedule import RThread


class ScheduleImportReporter(object):
    def __init__(self, subject=u"Rasp Report"):
        self.subject = subject
        self.report_list = []

    def add_report(self, title, message):
        if title and message:
            self.report_list.append((title, message))

    def send_report(self):
        """
        @return: bool report is not empty and was sent
        """

        if not self.report_list:
            return False

        parts = []

        for title, message in self.report_list:
            part = u" -- %s -- \n\n" % title
            part += message
            parts.append(part)

        delimiter = u"""

-----------------------------------

"""

        self.result_message = delimiter.join(parts)

        self._mail()

    def _mail(self):
        mail_process(self.subject, self.result_message)

    @classmethod
    def create_bus_import_reporter_for_supplier(cls, supplier):
        return ScheduleImportReporter(u"Отчет о импорте автобусов %s %s" % (supplier.code, supplier.title))

    @classmethod
    def create_import_reporter_by_supplier_and_t_type(cls, supplier, t_type):
        return ScheduleImportReporter(u"Отчет о импорте %s %s тип транспорта %s" %
                                      (supplier.code, supplier.title, t_type.title_ru))

    @classmethod
    def create_import_reporter_by_tsi_package(cls, package):
        return ScheduleImportReporter(u"Отчет о импорте пакета %s %s поставщика %s" %
                                      (package.id, package.title, package.supplier.title))

    @classmethod
    def send_bus_report(cls, supplier, *report_sources):
        reporter = cls.create_bus_import_reporter_for_supplier(supplier)

        reporter.add_report(u"Отчет о импорте", u"Загрузили %s ниток" %
                            RThread.objects.filter(supplier=supplier, route__two_stage_package=None).count())

        for source in report_sources:
            source.add_report_to_reporter(reporter)

        reporter.send_report()
